/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.infinitylib.modules.entitytargeting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EntityTargetingHandler {
    private static final EntityTargetingHandler INSTANCE = new EntityTargetingHandler();
    private Map<Class<? extends MobEntity>, List<Class<? extends Entity>>> targetMap = new HashMap<Class<? extends MobEntity>, List<Class<? extends Entity>>>();

    static EntityTargetingHandler getInstance() {
        return INSTANCE;
    }

    private EntityTargetingHandler() {
    }

    void registerEntityTargetingRule(Class<? extends Entity> target, Class<? extends MobEntity> aggressor) {
        if (!this.targetMap.containsKey(aggressor)) {
            this.targetMap.put(aggressor, new ArrayList());
        }
        this.targetMap.get(aggressor).add(target);
    }

    @SubscribeEvent
    public void onZombieSpawn(LivingSpawnEvent event) {
        if (!(event.getEntity() instanceof MobEntity)) {
            return;
        }
        MobEntity entity = (MobEntity)event.getEntity();
        for (Map.Entry<Class<? extends MobEntity>, List<Class<? extends Entity>>> entry : this.targetMap.entrySet()) {
            if (!entry.getKey().isAssignableFrom(entity.getClass())) continue;
            for (Class<? extends Entity> entityClass : entry.getValue()) {
                entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal(entity, entityClass, true));
            }
        }
    }
}

