/*
 * Decompiled with CFR 0.152.
 */
package fudge.notenoughcrashes.mixins.client;

import fudge.notenoughcrashes.mixinhandlers.EntryPointCatcher;
import fudge.notenoughcrashes.mixinhandlers.InGameCatcher;
import fudge.notenoughcrashes.stacktrace.CrashUtils;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.crash.CrashReport;
import net.minecraft.util.concurrent.RecursiveEventLoop;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraftClient
extends RecursiveEventLoop<Runnable> {
    @Shadow
    private CrashReport field_71433_S;
    @Shadow
    @Final
    private Queue<Runnable> field_213275_aU;

    public MixinMinecraftClient(String string_1) {
        super(string_1);
    }

    @Inject(method={"run()V"}, at={@At(value="HEAD")})
    private void beforeRun(CallbackInfo ci) {
        if (EntryPointCatcher.crashedDuringStartup()) {
            EntryPointCatcher.displayInitErrorScreen();
        }
    }

    @Inject(method={"run()V"}, at={@At(value="FIELD", target="Lnet/minecraft/client/MinecraftClient;crashReport:Lnet/minecraft/util/crash/CrashReport;")})
    private void onRunLoop(CallbackInfo ci) {
        if (this.field_71433_S != null) {
            InGameCatcher.handleServerCrash(this.field_71433_S);
            this.field_71433_S = null;
        }
    }

    @Inject(method={"run()V"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/client/MinecraftClient;addDetailsToCrashReport(Lnet/minecraft/util/crash/CrashReport;)Lnet/minecraft/util/crash/CrashReport;")}, cancellable=true)
    private void afterCrashHandled(CallbackInfo ci) {
        ci.cancel();
        Minecraft.func_71410_x().func_99999_d();
    }

    @ModifyArg(method={"run()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;addDetailsToCrashReport(Lnet/minecraft/util/crash/CrashReport;)Lnet/minecraft/util/crash/CrashReport;"))
    private CrashReport onCrash(CrashReport report) {
        InGameCatcher.handleClientCrash(report, this.field_213275_aU);
        return report;
    }

    @Redirect(method={"startIntegratedServer"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/MinecraftClient;printCrashReport(Lnet/minecraft/util/crash/CrashReport;)V"))
    private void redirectPrintCrashReport(CrashReport report) {
        CrashUtils.outputReport(report);
    }

    @Overwrite
    public void func_71398_f() {
        InGameCatcher.resetGameState(this.field_213275_aU);
    }
}

