/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.common.multiblock;

import com.google.gson.annotations.SerializedName;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.math.BlockPos;
import vazkii.patchouli.api.IStateMatcher;
import vazkii.patchouli.common.multiblock.AbstractMultiblock;
import vazkii.patchouli.common.multiblock.DenseMultiblock;
import vazkii.patchouli.common.multiblock.SparseMultiblock;
import vazkii.patchouli.common.multiblock.StateMatcher;
import vazkii.patchouli.common.multiblock.StringStateMatcher;

public class SerializedMultiblock {
    @SerializedName(value="pattern")
    private String[][] densePattern = null;
    @SerializedName(value="sparse_pattern")
    private Map<String, List<List<Integer>>> sparsePattern = null;
    private Map<String, String> mapping = new HashMap<String, String>();
    private boolean symmetrical = false;
    private int[] offset = new int[]{0, 0, 0};

    private static char assertValidMappingKey(String s) {
        if (s.length() != 1) {
            throw new IllegalArgumentException(s + " is an invalid mapping key, every mapping key must be 1 character long");
        }
        return s.charAt(0);
    }

    private static Map<Character, IStateMatcher> deserializeMapping(Map<String, String> mapping) {
        HashMap<Character, IStateMatcher> ret = new HashMap<Character, IStateMatcher>(mapping.size());
        for (Map.Entry<String, String> e : mapping.entrySet()) {
            IStateMatcher matcher;
            char key = SerializedMultiblock.assertValidMappingKey(e.getKey());
            String value = e.getValue();
            try {
                matcher = StringStateMatcher.fromString(value);
            }
            catch (CommandSyntaxException ex) {
                throw new IllegalArgumentException("Failure parsing state matcher", ex);
            }
            ret.put(Character.valueOf(key), matcher);
        }
        if (!ret.containsKey(Character.valueOf('_'))) {
            ret.put(Character.valueOf('_'), StateMatcher.ANY);
        }
        if (!ret.containsKey(Character.valueOf(' '))) {
            ret.put(Character.valueOf(' '), StateMatcher.AIR);
        }
        if (!ret.containsKey(Character.valueOf('0'))) {
            ret.put(Character.valueOf('0'), StateMatcher.AIR);
        }
        return ret;
    }

    private SparseMultiblock deserializeSparse() {
        Map<Character, IStateMatcher> matchers = SerializedMultiblock.deserializeMapping(this.mapping);
        HashMap<BlockPos, IStateMatcher> data = new HashMap<BlockPos, IStateMatcher>();
        for (Map.Entry<String, List<List<Integer>>> e : this.sparsePattern.entrySet()) {
            char key = SerializedMultiblock.assertValidMappingKey(e.getKey());
            this.assertMappingContains(key);
            List<List<Integer>> positions = e.getValue();
            for (List<Integer> position : positions) {
                if (position.size() != 3) {
                    throw new IllegalArgumentException("Position has more than three coordinates: " + position);
                }
                BlockPos pos = new BlockPos(position.get(0).intValue(), position.get(1).intValue(), position.get(2).intValue());
                data.put(pos, matchers.get(Character.valueOf(key)));
            }
        }
        return new SparseMultiblock(data);
    }

    private void assertMappingContains(char c) {
        if (c != '0' && c != '_' && c != ' ' && !this.mapping.containsKey(String.valueOf(c))) {
            throw new IllegalArgumentException("Character " + c + " in multiblock isn't mapped to a block");
        }
    }

    public DenseMultiblock deserializeDense() {
        String[][] stringArray = this.densePattern;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] line;
            for (String s : line = stringArray[i]) {
                for (char c : s.toCharArray()) {
                    this.assertMappingContains(c);
                }
            }
        }
        return new DenseMultiblock(this.densePattern, SerializedMultiblock.deserializeMapping(this.mapping));
    }

    public AbstractMultiblock toMultiblock() {
        if (this.densePattern != null == (this.sparsePattern != null)) {
            throw new IllegalArgumentException("One and only one of pattern and sparse_pattern should be specified");
        }
        AbstractMultiblock mb = this.densePattern != null ? this.deserializeDense() : this.deserializeSparse();
        mb.setSymmetrical(this.symmetrical);
        mb.offset(this.offset[0], this.offset[1], this.offset[2]);
        return mb;
    }
}

