/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers.entities.ai.tasks;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.brain.BrainUtil;
import net.minecraft.entity.ai.brain.task.SpawnGolemTask;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.Effects;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.potion.Potions;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.server.ServerWorld;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.configuration.GuardConfig;

public class HealGuardAndPlayerTask
extends SpawnGolemTask {
    private LivingEntity entityToHeal;
    private int rangedAttackTime = -1;
    private int seeTime;
    private final int attackIntervalMin;
    private final int maxRangedAttackTime;
    private final float attackRadius;
    private final float maxAttackDistance;

    public HealGuardAndPlayerTask(int p_i1650_4_, int maxAttackTime, float maxAttackDistanceIn) {
        this.attackIntervalMin = p_i1650_4_;
        this.maxRangedAttackTime = 0;
        this.attackRadius = maxAttackDistanceIn;
        this.maxAttackDistance = maxAttackDistanceIn * maxAttackDistanceIn;
    }

    protected boolean func_212832_a_(ServerWorld worldIn, VillagerEntity owner) {
        if (!GuardConfig.ClericHealing) {
            return false;
        }
        if (owner.func_213700_eh().func_221130_b() != VillagerProfession.field_221155_e || owner.func_70608_bn()) {
            return false;
        }
        List list = owner.field_70170_p.func_217357_a(LivingEntity.class, owner.func_174813_aQ().func_72314_b(10.0, 3.0, 10.0));
        if (!list.isEmpty()) {
            for (LivingEntity entityToHeal : list) {
                if (entityToHeal == null || !(entityToHeal.func_200600_R() == GuardEntityType.GUARD.get() && entityToHeal != null && entityToHeal.func_70089_S() && entityToHeal.func_110143_aJ() < entityToHeal.func_110138_aP()) && (!(entityToHeal instanceof PlayerEntity) || !entityToHeal.func_70644_a(Effects.field_220310_F) || ((PlayerEntity)entityToHeal).field_71075_bZ.field_75098_d || !(entityToHeal.func_110143_aJ() < entityToHeal.func_110138_aP()))) continue;
                this.entityToHeal = entityToHeal;
                return true;
            }
        }
        return false;
    }

    protected boolean func_212834_g_(ServerWorld worldIn, VillagerEntity entityIn, long gameTimeIn) {
        return this.entityToHeal.func_70089_S() && this.entityToHeal.func_110143_aJ() < this.entityToHeal.func_110138_aP() && this.func_212832_a_(worldIn, entityIn);
    }

    protected void updateTask(ServerWorld worldIn, VillagerEntity owner, long gameTime) {
        if (this.entityToHeal == null) {
            return;
        }
        double d0 = owner.func_70092_e(this.entityToHeal.func_226277_ct_(), this.entityToHeal.func_226278_cu_(), this.entityToHeal.func_226281_cx_());
        boolean flag = owner.func_70635_at().func_75522_a((Entity)this.entityToHeal);
        this.seeTime = flag ? ++this.seeTime : 0;
        BrainUtil.func_220625_c((LivingEntity)owner, (LivingEntity)this.entityToHeal);
        owner.func_70625_a((Entity)this.entityToHeal, 90.0f, 90.0f);
        if (!(d0 > (double)this.maxAttackDistance) && this.seeTime >= 5) {
            owner.func_70661_as().func_75499_g();
        } else {
            owner.func_70661_as().func_75497_a((Entity)this.entityToHeal, (double)owner.func_70689_ay());
        }
        if ((double)this.entityToHeal.func_70032_d((Entity)owner) <= 5.0) {
            owner.func_70605_aq().func_188488_a(-0.5f, 0.0f);
        }
        if (--this.rangedAttackTime == 0 && this.entityToHeal.func_110143_aJ() < this.entityToHeal.func_110138_aP() && this.entityToHeal.func_70089_S()) {
            if (!flag) {
                return;
            }
            float f = this.attackRadius;
            float lvt_5_1_ = MathHelper.func_76131_a((float)f, (float)0.5f, (float)0.5f);
            this.throwPotion(owner, this.entityToHeal, lvt_5_1_);
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        } else if (this.rangedAttackTime < 0 && (double)owner.func_70032_d((Entity)this.entityToHeal) >= 5.0) {
            float f2 = MathHelper.func_76133_a((double)d0) / this.attackRadius;
            this.rangedAttackTime = MathHelper.func_76141_d((float)(f2 * (float)(this.maxRangedAttackTime - this.attackIntervalMin) + (float)this.attackIntervalMin));
        }
    }

    public void throwPotion(VillagerEntity villager, LivingEntity target, float distanceFactor) {
        Vector3d vec3d = target.func_213322_ci();
        double d0 = target.func_226277_ct_() + vec3d.field_72450_a - villager.func_226277_ct_();
        double d1 = target.func_226280_cw_() - (double)1.1f - villager.func_226278_cu_();
        double d2 = target.func_226281_cx_() + vec3d.field_72449_c - villager.func_226281_cx_();
        float f = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        Potion potion = Potions.field_185220_C;
        potion = target.func_110143_aJ() <= 4.0f ? Potions.field_185250_v : Potions.field_185220_C;
        BrainUtil.func_220625_c((LivingEntity)villager, (LivingEntity)target);
        PotionEntity potionentity = new PotionEntity(villager.field_70170_p, (LivingEntity)villager);
        potionentity.func_213884_b(PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_185155_bH), (Potion)potion));
        potionentity.field_70125_A -= -20.0f;
        potionentity.func_70186_c(d0, d1 + (double)(f * 0.2f), d2, 0.75f, 8.0f);
        villager.field_70170_p.func_184148_a((PlayerEntity)null, villager.func_226277_ct_(), villager.func_226278_cu_(), villager.func_226281_cx_(), SoundEvents.field_187827_fP, villager.func_184176_by(), 1.0f, 0.8f + villager.func_70681_au().nextFloat() * 0.4f);
        villager.field_70170_p.func_217376_c((Entity)potionentity);
    }
}

