/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbranks.api;

import java.util.NoSuchElementException;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nullable;

public class OptionalBoolean {
    public static final OptionalBoolean EMPTY = new OptionalBoolean(null);
    public static final OptionalBoolean TRUE = new OptionalBoolean(true);
    public static final OptionalBoolean FALSE = new OptionalBoolean(false);
    private final Boolean value;

    public static OptionalBoolean ofNullable(@Nullable Boolean v) {
        return v == null ? EMPTY : OptionalBoolean.of(v);
    }

    public static OptionalBoolean of(boolean v) {
        return v ? TRUE : FALSE;
    }

    private OptionalBoolean(@Nullable Boolean v) {
        this.value = v;
    }

    public boolean orElse(boolean b) {
        return this.value == null ? b : this.value;
    }

    public boolean get() {
        if (this.value == null) {
            throw new NoSuchElementException("No value present");
        }
        return this.value;
    }

    public boolean isPresent() {
        return this.value != null;
    }

    public void ifPresent(Consumer consumer) {
        if (this.value != null) {
            consumer.accept(this.value);
        }
    }

    public boolean orElseGet(BooleanSupplier other) {
        return this.value != null ? this.value.booleanValue() : other.getAsBoolean();
    }

    public <X extends Throwable> boolean orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.value != null) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    @FunctionalInterface
    public static interface Consumer {
        public void accept(boolean var1);
    }
}

