/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.Collections;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.item.IHornHarvestable;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;

public class ItemHorn
extends Item {
    public ItemHorn(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, @Nonnull Hand hand) {
        player.func_184598_c(hand);
        return ActionResult.func_226249_b_((Object)player.func_184586_b(hand));
    }

    public void func_219972_a(World world, @Nonnull LivingEntity player, @Nonnull ItemStack stack, int time) {
        if (!world.field_72995_K) {
            if (time != this.func_77626_a(stack) && time % 5 == 0) {
                ItemHorn.breakGrass(world, stack, player.func_233580_cy_());
            }
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187679_dF, SoundCategory.BLOCKS, 1.0f, 0.001f);
        }
    }

    public static void breakGrass(World world, ItemStack stack, BlockPos srcPos) {
        IHornHarvestable.EnumHornType type = null;
        if (stack.func_77973_b() == ModItems.grassHorn) {
            type = IHornHarvestable.EnumHornType.WILD;
        } else if (stack.func_77973_b() == ModItems.leavesHorn) {
            type = IHornHarvestable.EnumHornType.CANOPY;
        } else if (stack.func_77973_b() == ModItems.snowHorn) {
            type = IHornHarvestable.EnumHornType.COVERING;
        }
        int range = 12 - type.ordinal() * 3;
        int rangeY = 3 + type.ordinal() * 4;
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.func_218278_a((BlockPos)srcPos.func_177982_a(-range, -rangeY, -range), (BlockPos)srcPos.func_177982_a(range, rangeY, range))) {
            Block block = world.func_180495_p(pos).func_177230_c();
            IHornHarvestable harvestable = BotaniaAPI.instance().getHornHarvestable(block).orElse(null);
            if (!(harvestable != null ? harvestable.canHornHarvest(world, pos, stack, type) : type == IHornHarvestable.EnumHornType.WILD && block instanceof BushBlock && !block.func_203417_a(ModTags.Blocks.SPECIAL_FLOWERS) || type == IHornHarvestable.EnumHornType.CANOPY && BlockTags.field_206952_E.func_230235_a_((Object)block) || type == IHornHarvestable.EnumHornType.COVERING && block == Blocks.field_150433_aE)) continue;
            coords.add(pos.func_185334_h());
        }
        Collections.shuffle(coords, world.field_73012_v);
        int count = Math.min(coords.size(), 32 + type.ordinal() * 16);
        for (int i = 0; i < count; ++i) {
            BlockPos currCoords = (BlockPos)coords.get(i);
            BlockState state = world.func_180495_p(currCoords);
            Block block = state.func_177230_c();
            IHornHarvestable harvestable = BotaniaAPI.instance().getHornHarvestable(block).orElse(null);
            if (harvestable != null && harvestable.hasSpecialHornHarvest(world, currCoords, stack, type)) {
                harvestable.harvestByHorn(world, currCoords, stack, type);
                continue;
            }
            world.func_175655_b(currCoords, true);
        }
    }
}

