/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.tile;

import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.villager.VillagerType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.server.ServerWorld;
import vazkii.botania.common.block.tile.ModTiles;
import vazkii.botania.common.block.tile.TileMod;
import vazkii.botania.common.lib.ModTags;

public class TileCocoon
extends TileMod
implements ITickableTileEntity {
    private static final String TAG_TIME_PASSED = "timePassed";
    private static final String TAG_EMERALDS_GIVEN = "emeraldsGiven";
    private static final String TAG_CHORUS_FRUIT_GIVEN = "chorusFruitGiven";
    private static final String TAG_GAIA_SPIRIT_GIVEN = "gaiaSpiritGiven";
    public static final int TOTAL_TIME = 2400;
    public static final int MAX_EMERALDS = 20;
    public static final int MAX_CHORUS_FRUITS = 20;
    private static final float SPECIAL_CHANCE = 0.075f;
    public int timePassed;
    public int emeraldsGiven;
    public int chorusFruitGiven;
    public boolean gaiaSpiritGiven;

    public TileCocoon() {
        super(ModTiles.COCOON);
    }

    public void func_73660_a() {
        ++this.timePassed;
        if (this.timePassed >= 2400) {
            this.hatch();
        }
    }

    private void hatch() {
        if (!this.field_145850_b.field_72995_K) {
            this.timePassed = 0;
            this.field_145850_b.func_175655_b(this.field_174879_c, false);
            MobEntity entity = null;
            BlockPos placePos = this.field_174879_c;
            float rareChance = this.gaiaSpiritGiven ? 1.0f : 0.075f;
            float villagerChance = Math.min(1.0f, (float)this.emeraldsGiven / 20.0f);
            float shulkerChance = Math.min(1.0f, (float)this.chorusFruitGiven / 20.0f);
            ArrayList<BlockPos> validWater = new ArrayList<BlockPos>();
            for (Direction d : Direction.values()) {
                BlockPos blockPos;
                BlockPos blockPos2 = blockPos = d == Direction.UP ? this.field_174879_c : this.field_174879_c.func_177972_a(d);
                if (!this.field_145850_b.func_175667_e(blockPos) || this.field_145850_b.func_180495_p(blockPos).func_177230_c() != Blocks.field_150355_j) continue;
                validWater.add(blockPos);
            }
            if (Math.random() < (double)shulkerChance) {
                entity = (MobEntity)EntityType.field_200738_ad.func_200721_a(this.field_145850_b);
            } else if (Math.random() < (double)villagerChance) {
                VillagerEntity villager = (VillagerEntity)EntityType.field_200756_av.func_200721_a(this.field_145850_b);
                if (villager != null) {
                    VillagerType type = VillagerType.func_242371_a((Optional)this.field_145850_b.func_242406_i(this.func_174877_v()));
                    villager.func_213753_a(villager.func_213700_eh().func_221134_a(type));
                }
                entity = villager;
            } else if (!validWater.isEmpty()) {
                placePos = (BlockPos)validWater.get(this.field_145850_b.field_73012_v.nextInt(validWater.size()));
                entity = Math.random() < (double)rareChance ? this.random((ITag<EntityType<?>>)ModTags.Entities.COCOON_RARE_AQUATIC) : this.random((ITag<EntityType<?>>)ModTags.Entities.COCOON_COMMON_AQUATIC);
            } else {
                entity = Math.random() < (double)rareChance ? this.random((ITag<EntityType<?>>)ModTags.Entities.COCOON_RARE) : this.random((ITag<EntityType<?>>)ModTags.Entities.COCOON_COMMON);
            }
            if (entity != null) {
                entity.func_70107_b((double)placePos.func_177958_n() + 0.5, (double)placePos.func_177956_o() + 0.5, (double)placePos.func_177952_p() + 0.5);
                if (entity instanceof AgeableEntity) {
                    ((AgeableEntity)entity).func_70873_a(-24000);
                }
                entity.func_213386_a((IServerWorld)((ServerWorld)this.field_145850_b), this.field_145850_b.func_175649_E(this.func_174877_v()), SpawnReason.EVENT, null, null);
                entity.func_110163_bv();
                this.field_145850_b.func_217376_c((Entity)entity);
                entity.func_70656_aK();
            }
        }
    }

    public void forceRare() {
        this.gaiaSpiritGiven = true;
        this.timePassed = Math.max(this.timePassed, 1200);
    }

    private MobEntity random(ITag<EntityType<?>> tag) {
        Entity entity;
        EntityType type = (EntityType)tag.func_205596_a(this.field_145850_b.field_73012_v);
        if (type == EntityType.field_200796_j && (double)this.field_145850_b.field_73012_v.nextFloat() < 0.01) {
            type = EntityType.field_200780_T;
        }
        return (entity = type.func_200721_a(this.field_145850_b)) instanceof MobEntity ? (MobEntity)entity : null;
    }

    @Override
    public void writePacketNBT(CompoundNBT cmp) {
        cmp.func_74768_a(TAG_TIME_PASSED, this.timePassed);
        cmp.func_74768_a(TAG_EMERALDS_GIVEN, this.emeraldsGiven);
        cmp.func_74768_a(TAG_CHORUS_FRUIT_GIVEN, this.chorusFruitGiven);
        cmp.func_74757_a(TAG_GAIA_SPIRIT_GIVEN, this.gaiaSpiritGiven);
    }

    @Override
    public void readPacketNBT(CompoundNBT cmp) {
        this.timePassed = cmp.func_74762_e(TAG_TIME_PASSED);
        this.emeraldsGiven = cmp.func_74762_e(TAG_EMERALDS_GIVEN);
        this.chorusFruitGiven = cmp.func_74762_e(TAG_CHORUS_FRUIT_GIVEN);
        this.gaiaSpiritGiven = cmp.func_74767_n(TAG_GAIA_SPIRIT_GIVEN);
    }
}

