/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.IShearable;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.passive.CowEntity;
import net.minecraft.entity.passive.MooshroomEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IForgeShearable;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.item.ItemHorn;
import vazkii.botania.common.item.ModItems;

public class BlockForestDrum
extends BlockModWaterloggable
implements IManaTrigger {
    private static final VoxelShape SHAPE = Block.func_208617_a((double)3.0, (double)1.0, (double)3.0, (double)13.0, (double)15.0, (double)13.0);
    private final Variant variant;

    public BlockForestDrum(Variant v, AbstractBlock.Properties builder) {
        super(builder);
        this.variant = v;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    public void convertNearby(Entity entity, Item from, Item to) {
        World world = entity.field_70170_p;
        List items = world.func_217357_a(ItemEntity.class, entity.func_174813_aQ());
        for (ItemEntity item : items) {
            ItemStack itemstack = item.func_92059_d();
            if (itemstack.func_190926_b() || itemstack.func_77973_b() != from || world.field_72995_K) continue;
            while (itemstack.func_190916_E() > 0) {
                ItemEntity ent = entity.func_70099_a(new ItemStack((IItemProvider)to), 1.0f);
                ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)(world.field_73012_v.nextFloat() * 0.05f), (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f), (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f)));
                itemstack.func_190918_g(1);
            }
            item.func_70106_y();
        }
    }

    @Override
    public void onBurstCollision(IManaBurst burst, World world, BlockPos pos) {
        if (burst.isFake()) {
            return;
        }
        if (world.field_72995_K) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197597_H, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 1.2, (double)pos.func_177952_p() + 0.5, 0.041666666666666664, 0.0, 0.0);
            return;
        }
        if (this.variant == Variant.WILD) {
            ItemHorn.breakGrass(world, new ItemStack((IItemProvider)ModItems.grassHorn), pos);
        } else if (this.variant == Variant.CANOPY) {
            ItemHorn.breakGrass(world, new ItemStack((IItemProvider)ModItems.leavesHorn), pos);
        } else {
            int range = 10;
            List entities = world.func_217357_a(MobEntity.class, new AxisAlignedBB(pos.func_177982_a(-range, -range, -range), pos.func_177982_a(range + 1, range + 1, range + 1)));
            ArrayList<MobEntity> shearables = new ArrayList<MobEntity>();
            ItemStack stack = new ItemStack((IItemProvider)ModBlocks.gatheringDrum);
            for (MobEntity entity : entities) {
                if (entity instanceof CowEntity) {
                    this.convertNearby((Entity)entity, Items.field_151133_ar, Items.field_151117_aB);
                    if (!(entity instanceof MooshroomEntity)) continue;
                    this.convertNearby((Entity)entity, Items.field_151054_z, Items.field_151009_A);
                    continue;
                }
                if ((!(entity instanceof IShearable) || !((IShearable)entity).func_230262_K__()) && (!(entity instanceof IForgeShearable) || !((IForgeShearable)entity).isShearable(stack, world, entity.func_233580_cy_()))) continue;
                shearables.add(entity);
            }
            Collections.shuffle(shearables);
            int sheared = 0;
            for (MobEntity entity : shearables) {
                if (sheared > 4) break;
                if (entity instanceof IShearable) {
                    ((IShearable)entity).func_230263_a_(SoundCategory.BLOCKS);
                } else {
                    List stacks = ((IForgeShearable)entity).onSheared(null, stack, world, entity.func_233580_cy_(), 0);
                    for (ItemStack wool : stacks) {
                        ItemEntity ent = entity.func_70099_a(wool, 1.0f);
                        ent.func_213317_d(ent.func_213322_ci().func_72441_c((double)(world.field_73012_v.nextFloat() * 0.05f), (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f), (double)((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.1f)));
                    }
                }
                ++sheared;
            }
        }
        for (int i = 0; i < 10; ++i) {
            world.func_184133_a(null, pos, SoundEvents.field_187676_dE, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
    }

    public static enum Variant {
        WILD,
        GATHERING,
        CANOPY;

    }
}

