/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.world.chunk;

import com.google.common.collect.Lists;
import com.performant.coremod.acessorInterfaces.ChunkManagerGetChunks;
import com.performant.coremod.config.ConfigurationCache;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.GameRules;
import net.minecraft.world.chunk.AbstractChunkProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.IChunk;
import net.minecraft.world.server.ChunkHolder;
import net.minecraft.world.server.ChunkManager;
import net.minecraft.world.server.ServerChunkProvider;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.server.TicketManager;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraft.world.storage.IWorldInfo;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={ServerChunkProvider.class}, priority=999)
public abstract class ServerChunkProviderMixin
extends AbstractChunkProvider {
    ServerChunkProvider self = (ServerChunkProvider)this;
    @Shadow
    private long field_217245_k;
    @Shadow
    @Final
    private TicketManager field_217240_d;
    @Shadow
    private boolean field_217246_l;
    @Shadow
    private boolean field_217247_m;
    @Shadow
    @Final
    public ChunkManager field_217237_a;
    @Shadow
    private WorldEntitySpawner.EntityDensityManager field_241097_p_;
    @Shadow
    @Final
    public ServerWorld field_73251_h;
    private int spawnCounter = 0;

    @Shadow
    public abstract void func_241098_a_(long var1, Consumer<Chunk> var3);

    @Shadow
    @Nullable
    public abstract IChunk func_212849_a_(int var1, int var2, ChunkStatus var3, boolean var4);

    @Overwrite
    private void func_217220_m() {
        long gameTime = this.field_73251_h.func_82737_E();
        long timeDiff = gameTime - this.field_217245_k;
        this.field_217245_k = gameTime;
        IWorldInfo iworldinfo = this.field_73251_h.func_72912_H();
        boolean disableTicking = this.field_73251_h.func_234925_Z_();
        boolean doesMobSpawning = this.field_73251_h.func_82736_K().func_223586_b(GameRules.field_223601_d);
        if (!disableTicking) {
            this.field_73251_h.func_217381_Z().func_76320_a("pollingChunks");
            int randomTickSpeed = this.field_73251_h.func_82736_K().func_223592_c(GameRules.field_223610_m) * 20;
            boolean shouldUpdate = iworldinfo.func_82573_f() % 400L == 0L;
            boolean shouldSpawnMobs = ++this.spawnCounter == ConfigurationCache.spawnInterval || shouldUpdate;
            boolean shouldTickEnv = iworldinfo.func_82573_f() % 20L == 0L;
            WorldEntitySpawner.EntityDensityManager densityManager = null;
            Long2ObjectLinkedOpenHashMap<ChunkHolder> chunkHolders = ((ChunkManagerGetChunks)this.field_217237_a).getLoadedChunksHashMap();
            LongSet chunks = this.field_217240_d.field_219381_i.field_215498_a.keySet();
            ArrayList spawnChunk = null;
            if (shouldSpawnMobs && !chunks.isEmpty()) {
                this.spawnCounter = 0;
                this.field_73251_h.func_217381_Z().func_76320_a("naturalSpawnCount");
                int spawningChunksCount = (int)((double)this.field_217240_d.func_219358_b() * ConfigurationCache.entityDensity);
                this.field_241097_p_ = densityManager = WorldEntitySpawner.func_234964_a_((int)spawningChunksCount, (Iterable)this.field_73251_h.func_241136_z_(), this::func_241098_a_);
                this.field_73251_h.func_217381_Z().func_76319_b();
                spawnChunk = Lists.newArrayList((Iterable)chunks);
                Collections.shuffle(spawnChunk);
            }
            Iterator iterator = (spawnChunk == null ? chunks : spawnChunk).iterator();
            while (iterator.hasNext()) {
                Optional optional;
                long pos = (Long)iterator.next();
                ChunkHolder chunkHolder = (ChunkHolder)chunkHolders.get(pos);
                if (chunkHolder == null || !(optional = chunkHolder.func_219296_a().getNow(ChunkHolder.field_219308_c).left()).isPresent()) continue;
                this.field_73251_h.func_217381_Z().func_76320_a("broadcast");
                chunkHolder.func_219274_a((Chunk)optional.get());
                this.field_73251_h.func_217381_Z().func_76319_b();
                Optional optional1 = chunkHolder.func_219297_b().getNow(ChunkHolder.field_219308_c).left();
                if (!optional1.isPresent()) continue;
                Chunk chunk = (Chunk)optional1.get();
                chunk.func_177415_c(chunk.func_177416_w() + timeDiff);
                if (doesMobSpawning && shouldSpawnMobs && (this.field_217246_l || this.field_217247_m) && this.field_73251_h.func_175723_af().func_177730_a(chunk.func_76632_l())) {
                    WorldEntitySpawner.func_234979_a_((ServerWorld)this.field_73251_h, (Chunk)chunk, (WorldEntitySpawner.EntityDensityManager)densityManager, (boolean)this.field_217247_m, (boolean)this.field_217246_l, (boolean)shouldUpdate);
                }
                if (!shouldTickEnv) continue;
                this.field_73251_h.func_217441_a(chunk, randomTickSpeed);
            }
            this.field_73251_h.func_217381_Z().func_76320_a("customSpawners");
            if (doesMobSpawning) {
                this.field_73251_h.func_241123_a_(this.field_217246_l, this.field_217247_m);
            }
            this.field_73251_h.func_217381_Z().func_76319_b();
            this.field_73251_h.func_217381_Z().func_76319_b();
        }
        this.field_217237_a.func_219169_g();
    }
}

