/*
 * Decompiled with CFR 0.152.
 */
package com.performant.coremod.mixin.world.chunk;

import com.performant.coremod.config.ConfigurationCache;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.village.PointOfInterestManager;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.chunk.storage.ChunkSerializer;
import net.minecraft.world.gen.feature.template.TemplateManager;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChunkSerializer.class})
public class ChunkSerializerMixin {
    @Inject(method={"read"}, at={@At(value="HEAD")})
    private static void before(ServerWorld worldIn, TemplateManager templateManagerIn, PointOfInterestManager poiManager, ChunkPos pos, CompoundNBT compound, CallbackInfoReturnable<ChunkPrimer> cir) {
        if (pos != null && Thread.currentThread().getName().contains("server")) {
            ConfigurationCache.currentLoaded = pos;
        }
    }

    @Inject(method={"read"}, at={@At(value="RETURN")})
    private static void after(ServerWorld worldIn, TemplateManager templateManagerIn, PointOfInterestManager poiManager, ChunkPos pos, CompoundNBT compound, CallbackInfoReturnable<ChunkPrimer> cir) {
        if (Thread.currentThread().getName().contains("server")) {
            ConfigurationCache.currentLoaded = ConfigurationCache.NONE;
        }
    }
}

