/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.config.gui.modules;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.config.gui.modules.ModulesScreen;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.CoordsModule;
import me.cominixo.betterf3.modules.FpsModule;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModuleListWidget
extends ExtendedList<ModuleEntry> {
    ModulesScreen screen;
    List<ModuleEntry> moduleEntries = new ArrayList<ModuleEntry>();

    public ModuleListWidget(ModulesScreen screen, Minecraft client, int width, int height, int top, int bottom, int entryHeight) {
        super(client, width, height, top, bottom, entryHeight);
        this.screen = screen;
    }

    protected int func_230952_d_() {
        return super.func_230952_d_() + 30;
    }

    public int func_230949_c_() {
        return super.func_230949_c_() + 85;
    }

    public ModuleEntry getEntry(int index) {
        return this.moduleEntries.get(index);
    }

    public void setModules(List<BaseModule> modules) {
        this.moduleEntries.clear();
        this.func_230963_j_();
        for (BaseModule module : modules) {
            this.addModule(module);
        }
    }

    public void updateModules() {
        this.func_230963_j_();
        this.moduleEntries.forEach(arg_0 -> ((ModuleListWidget)this).func_230513_b_(arg_0));
    }

    public void addModule(BaseModule module) {
        ModuleEntry entry = new ModuleEntry(this.screen, module);
        this.moduleEntries.add(entry);
        this.func_230513_b_((AbstractList.AbstractListEntry)entry);
    }

    public void removeModule(int index) {
        ModuleEntry entry = this.moduleEntries.get(index);
        this.moduleEntries.remove((Object)entry);
        this.func_230956_e_((AbstractList.AbstractListEntry)entry);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class ModuleEntry
    extends ExtendedList.AbstractListEntry<ModuleEntry> {
        private final ModulesScreen screen;
        private final Minecraft client;
        public final BaseModule module;

        protected ModuleEntry(ModulesScreen screen, BaseModule module) {
            this.screen = screen;
            this.module = module;
            this.client = Minecraft.func_71410_x();
        }

        public void func_230432_a_(MatrixStack matrices, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            Object exampleText;
            this.client.field_71466_p.func_238421_b_(matrices, this.module.toString(), (float)(x + 32 + 3), (float)(y + 1), 0xFFFFFF);
            if (this.module instanceof CoordsModule) {
                CoordsModule coordsModule = (CoordsModule)this.module;
                exampleText = Utils.getStyledText("X", coordsModule.colorX).func_230529_a_((ITextComponent)Utils.getStyledText("Y", coordsModule.colorY)).func_230529_a_((ITextComponent)Utils.getStyledText("Z", coordsModule.colorZ)).func_230529_a_((ITextComponent)Utils.getStyledText(": ", coordsModule.nameColor)).func_230529_a_((ITextComponent)Utils.getStyledText("100 ", coordsModule.colorX).func_230529_a_((ITextComponent)Utils.getStyledText("200 ", coordsModule.colorY)).func_230529_a_((ITextComponent)Utils.getStyledText("300", coordsModule.colorZ)));
            } else if (this.module instanceof FpsModule) {
                FpsModule fpsModule = (FpsModule)this.module;
                exampleText = Utils.getStyledText("60 fps  ", fpsModule.colorHigh).func_230529_a_((ITextComponent)Utils.getStyledText("40 fps  ", fpsModule.colorMed)).func_230529_a_((ITextComponent)Utils.getStyledText("10 fps", fpsModule.colorLow));
            } else {
                exampleText = this.module.nameColor != null && this.module.valueColor != null ? Utils.getStyledText("Name: ", this.module.nameColor).func_230529_a_((ITextComponent)Utils.getStyledText("Value", this.module.valueColor)) : new StringTextComponent("");
            }
            this.client.field_71466_p.func_243248_b(matrices, (ITextComponent)exampleText, (float)(x + 40 + 3), (float)(y + 13), 0xFFFFFF);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.client.func_110434_K().func_110577_a(AbstractGui.field_230665_h_);
            if (this.client.field_71474_y.field_85185_A || hovered) {
                this.client.func_110434_K().func_110577_a(new ResourceLocation("textures/gui/server_selection.png"));
                int v = mouseX - x;
                int w = mouseY - y;
                if (index > 0) {
                    if (v < 16 && w < 16) {
                        AbstractGui.func_238463_a_((MatrixStack)matrices, (int)x, (int)y, (float)96.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                    } else {
                        AbstractGui.func_238463_a_((MatrixStack)matrices, (int)x, (int)y, (float)96.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                    }
                }
                if (index < ModuleListWidget.this.moduleEntries.size() - 1) {
                    if (v < 16 && w > 16) {
                        AbstractGui.func_238463_a_((MatrixStack)matrices, (int)x, (int)y, (float)64.0f, (float)32.0f, (int)32, (int)32, (int)256, (int)256);
                    } else {
                        AbstractGui.func_238463_a_((MatrixStack)matrices, (int)x, (int)y, (float)64.0f, (float)0.0f, (int)32, (int)32, (int)256, (int)256);
                    }
                }
            }
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int button) {
            double d = mouseX - (double)this.screen.modulesListWidget.func_230968_n_();
            double e = mouseY - (double)ModuleListWidget.this.func_230962_i_(ModuleListWidget.this.func_231039_at__().indexOf((Object)this));
            if (d <= 32.0) {
                int i = this.screen.modulesListWidget.func_231039_at__().indexOf((Object)this);
                if (d < 16.0 && e < 16.0 && i > 0) {
                    this.swapEntries(i, i - 1);
                    return true;
                }
                if (d < 16.0 && e > 16.0 && i < ModuleListWidget.this.moduleEntries.size() - 1) {
                    this.swapEntries(i, i + 1);
                    return true;
                }
            }
            ModuleListWidget.this.func_241215_a_((AbstractList.AbstractListEntry)this);
            this.screen.updateButtons();
            return false;
        }

        private void swapEntries(int i, int j) {
            ModuleEntry temp = ModuleListWidget.this.moduleEntries.get(i);
            ModuleListWidget.this.moduleEntries.set(i, ModuleListWidget.this.moduleEntries.get(j));
            ModuleListWidget.this.moduleEntries.set(j, temp);
            this.screen.modulesListWidget.func_241215_a_((AbstractList.AbstractListEntry)temp);
            this.screen.updateButtons();
            this.screen.modulesListWidget.updateModules();
        }
    }
}

