/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.config;

import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.file.FileConfig;
import java.io.File;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.config.GeneralOptions;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.CoordsModule;
import me.cominixo.betterf3.modules.EmptyModule;
import me.cominixo.betterf3.modules.FpsModule;
import me.cominixo.betterf3.utils.DebugLine;
import net.minecraft.util.text.Color;

public class ModConfigFile {
    public static Runnable saveRunnable = () -> {
        Object config = FileConfig.builder(Paths.get("config/betterf3.toml", new String[0])).concurrent().autosave().build();
        Config general = Config.inMemory();
        general.set("disable_mod", (Object)GeneralOptions.disableMod);
        general.set("space_modules", (Object)GeneralOptions.spaceEveryModule);
        general.set("shadow_text", (Object)GeneralOptions.shadowText);
        general.set("animations", (Object)GeneralOptions.enableAnimations);
        general.set("animationSpeed", (Object)GeneralOptions.animationSpeed);
        general.set("background_color", (Object)GeneralOptions.backgroundColor);
        ArrayList<Config> configsLeft = new ArrayList<Config>();
        for (BaseModule module : BaseModule.modules) {
            Config moduleConfig = ModConfigFile.saveModule(module);
            configsLeft.add(moduleConfig);
        }
        ArrayList<Config> configsRight = new ArrayList<Config>();
        for (BaseModule module : BaseModule.modulesRight) {
            Config moduleConfig = ModConfigFile.saveModule(module);
            configsRight.add(moduleConfig);
        }
        config.set("modules_left", configsLeft);
        config.set("modules_right", configsRight);
        config.set("general", (Object)general);
        config.close();
    };

    public static void load() {
        File file = new File("config/betterf3.toml");
        try {
            Config general;
            Object config = FileConfig.builder(file).concurrent().autosave().build();
            config.load();
            Config allModulesConfig = config.getOrElse("modules", () -> null);
            if (allModulesConfig != null) {
                for (BaseModule module : BaseModule.allModules) {
                    String moduleName = module.id;
                    Config moduleConfig = allModulesConfig.getOrElse(moduleName, () -> null);
                    if (moduleConfig == null) continue;
                    Config lines = moduleConfig.getOrElse("lines", () -> null);
                    if (lines != null) {
                        for (Config.Entry entry : lines.entrySet()) {
                            DebugLine line = module.getLine(entry.getKey());
                            if (line == null) continue;
                            line.enabled = (Boolean)entry.getValue();
                        }
                    }
                    if (module.defaultNameColor != null) {
                        module.nameColor = Color.func_240743_a_((int)moduleConfig.getOrElse("name_color", Integer.valueOf(module.defaultNameColor.func_240742_a_())));
                    }
                    if (module.defaultValueColor != null) {
                        module.valueColor = Color.func_240743_a_((int)moduleConfig.getOrElse("value_color", Integer.valueOf(module.defaultValueColor.func_240742_a_())));
                    }
                    if (module instanceof CoordsModule) {
                        CoordsModule coordsModule = (CoordsModule)module;
                        coordsModule.colorX = Color.func_240743_a_((int)moduleConfig.getOrElse("color_x", Integer.valueOf(coordsModule.defaultColorX.func_240742_a_())));
                        coordsModule.colorY = Color.func_240743_a_((int)moduleConfig.getOrElse("color_y", Integer.valueOf(coordsModule.defaultColorY.func_240742_a_())));
                        coordsModule.colorZ = Color.func_240743_a_((int)moduleConfig.getOrElse("color_z", Integer.valueOf(coordsModule.defaultColorZ.func_240742_a_())));
                    }
                    module.enabled = moduleConfig.getOrElse("enabled", Boolean.valueOf(true));
                }
            } else {
                List modulesRightConfig;
                ArrayList<BaseModule> modulesLeft = new ArrayList<BaseModule>();
                ArrayList<BaseModule> modulesRight = new ArrayList<BaseModule>();
                List modulesLeftConfig = config.getOrElse("modules_left", () -> null);
                if (modulesLeftConfig != null) {
                    for (Object moduleConfig : modulesLeftConfig) {
                        String moduleName = (String)moduleConfig.getOrElse("name", null);
                        if (moduleName == null) continue;
                        BaseModule baseModule = ModConfigFile.loadModule((Config)moduleConfig);
                        modulesLeft.add(baseModule);
                    }
                }
                if (!modulesLeft.isEmpty()) {
                    BaseModule.modules = modulesLeft;
                }
                if ((modulesRightConfig = config.getOrElse("modules_right", () -> null)) != null) {
                    for (Config moduleConfig : modulesRightConfig) {
                        String string = moduleConfig.getOrElse("name", () -> null);
                        if (string == null) continue;
                        BaseModule baseModule = ModConfigFile.loadModule(moduleConfig);
                        modulesRight.add(baseModule);
                    }
                }
                if (!modulesRight.isEmpty()) {
                    BaseModule.modulesRight = modulesRight;
                }
            }
            if ((general = config.getOrElse("general", () -> null)) != null) {
                if (allModulesConfig != null) {
                    BaseModule baseModule;
                    ArrayList<BaseModule> modulesLeft = new ArrayList<BaseModule>();
                    ArrayList<BaseModule> modulesRight = new ArrayList<BaseModule>();
                    for (Object s : general.getOrElse("modules_left_order", new ArrayList())) {
                        baseModule = BaseModule.getModuleById(s.toString());
                        if (baseModule == null) continue;
                        modulesLeft.add(baseModule);
                    }
                    if (!modulesLeft.isEmpty()) {
                        BaseModule.modules = modulesLeft;
                    }
                    for (Object s : general.getOrElse("modules_right_order", new ArrayList())) {
                        baseModule = BaseModule.getModuleById(s.toString());
                        if (baseModule == null) continue;
                        modulesRight.add(baseModule);
                    }
                    if (!modulesRight.isEmpty()) {
                        BaseModule.modulesRight = modulesRight;
                    }
                }
                GeneralOptions.disableMod = general.getOrElse("disable_mod", Boolean.valueOf(false));
                GeneralOptions.spaceEveryModule = general.getOrElse("space_modules", Boolean.valueOf(false));
                GeneralOptions.shadowText = general.getOrElse("shadow_text", Boolean.valueOf(true));
                GeneralOptions.enableAnimations = general.getOrElse("animations", Boolean.valueOf(true));
                GeneralOptions.animationSpeed = general.getOrElse("animationSpeed", Double.valueOf(1.0));
                GeneralOptions.backgroundColor = general.getOrElse("background_color", Integer.valueOf(1867534416));
            }
            config.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static BaseModule loadModule(Config moduleConfig) {
        BaseModule baseModule;
        String moduleName = (String)moduleConfig.getOrElse("name", null);
        try {
            baseModule = (BaseModule)BaseModule.getModuleById(moduleName).getClass().newInstance();
        }
        catch (IllegalAccessException | InstantiationException | NullPointerException e) {
            baseModule = EmptyModule.INSTANCE;
        }
        Config lines = moduleConfig.getOrElse("lines", () -> null);
        if (lines != null) {
            for (Config.Entry entry : lines.entrySet()) {
                DebugLine line = baseModule.getLine(entry.getKey());
                if (line == null) continue;
                line.enabled = (Boolean)entry.getValue();
            }
        }
        if (baseModule.defaultNameColor != null) {
            baseModule.nameColor = Color.func_240743_a_((int)moduleConfig.getOrElse("name_color", Integer.valueOf(baseModule.defaultNameColor.func_240742_a_())));
        }
        if (baseModule.defaultValueColor != null) {
            baseModule.valueColor = Color.func_240743_a_((int)moduleConfig.getOrElse("value_color", Integer.valueOf(baseModule.defaultValueColor.func_240742_a_())));
        }
        if (baseModule instanceof CoordsModule) {
            CoordsModule coordsModule = (CoordsModule)baseModule;
            coordsModule.colorX = Color.func_240743_a_((int)moduleConfig.getOrElse("color_x", Integer.valueOf(coordsModule.defaultColorX.func_240742_a_())));
            coordsModule.colorY = Color.func_240743_a_((int)moduleConfig.getOrElse("color_y", Integer.valueOf(coordsModule.defaultColorY.func_240742_a_())));
            coordsModule.colorZ = Color.func_240743_a_((int)moduleConfig.getOrElse("color_z", Integer.valueOf(coordsModule.defaultColorZ.func_240742_a_())));
        }
        if (baseModule instanceof FpsModule) {
            FpsModule fpsModule = (FpsModule)baseModule;
            fpsModule.colorHigh = Color.func_240743_a_((int)moduleConfig.getOrElse("color_high", Integer.valueOf(fpsModule.defaultColorHigh.func_240742_a_())));
            fpsModule.colorMed = Color.func_240743_a_((int)moduleConfig.getOrElse("color_med", Integer.valueOf(fpsModule.defaultColorMed.func_240742_a_())));
            fpsModule.colorLow = Color.func_240743_a_((int)moduleConfig.getOrElse("color_low", Integer.valueOf(fpsModule.defaultColorLow.func_240742_a_())));
        }
        baseModule.enabled = moduleConfig.getOrElse("enabled", Boolean.valueOf(true));
        return baseModule;
    }

    private static Config saveModule(BaseModule module) {
        Config moduleConfig = Config.inMemory();
        Config lines = Config.inMemory();
        for (DebugLine line : module.getLines()) {
            String lineId = line.getId();
            lines.set(lineId, (Object)line.enabled);
        }
        moduleConfig.set("name", (Object)module.id);
        if (module.nameColor != null) {
            moduleConfig.set("name_color", (Object)module.nameColor.func_240742_a_());
        }
        if (module.valueColor != null) {
            moduleConfig.set("value_color", (Object)module.valueColor.func_240742_a_());
        }
        if (module instanceof CoordsModule) {
            CoordsModule coordsModule = (CoordsModule)module;
            if (coordsModule.colorX != null) {
                moduleConfig.set("color_x", (Object)coordsModule.colorX.func_240742_a_());
            }
            if (coordsModule.colorY != null) {
                moduleConfig.set("color_y", (Object)coordsModule.colorY.func_240742_a_());
            }
            if (coordsModule.colorZ != null) {
                moduleConfig.set("color_z", (Object)coordsModule.colorZ.func_240742_a_());
            }
        }
        if (module instanceof FpsModule) {
            FpsModule fpsModule = (FpsModule)module;
            if (fpsModule.colorHigh != null) {
                moduleConfig.set("color_high", (Object)fpsModule.colorHigh.func_240742_a_());
            }
            if (fpsModule.colorMed != null) {
                moduleConfig.set("color_med", (Object)fpsModule.colorMed.func_240742_a_());
            }
            if (fpsModule.colorLow != null) {
                moduleConfig.set("color_low", (Object)fpsModule.colorLow.func_240742_a_());
            }
        }
        moduleConfig.set("enabled", (Object)module.enabled);
        moduleConfig.set("lines", (Object)lines);
        return moduleConfig;
    }
}

