/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.sndctrl.audio.handlers;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.commons.lang3.StringUtils;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.logging.IModLog;
import org.orecruncher.lib.random.XorShiftRandom;
import org.orecruncher.sndctrl.SoundControl;
import org.orecruncher.sndctrl.api.acoustics.IAcoustic;
import org.orecruncher.sndctrl.api.acoustics.IAcousticFactory;
import org.orecruncher.sndctrl.api.sound.Category;
import org.orecruncher.sndctrl.audio.AudioEngine;
import org.orecruncher.sndctrl.audio.PlayerCenteredSoundInstance;
import org.orecruncher.sndctrl.config.Config;
import org.orecruncher.sndctrl.library.Primitives;

@Mod.EventBusSubscriber(modid="sndctrl", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class SoundEventHandling {
    private static final IModLog LOGGER = SoundControl.LOGGER.createChild(SoundEventHandling.class);
    private static boolean hasPlayed = false;

    private SoundEventHandling() {
    }

    @SubscribeEvent
    public static void onGuiOpen(@Nonnull GuiOpenEvent event) {
        if (!hasPlayed && event.getGui() instanceof MainMenuScreen) {
            hasPlayed = true;
            List possibles = ((List)Config.CLIENT.sound.startupSoundList.get()).stream().map(StringUtils::trim).filter(s -> s.length() > 0).collect(Collectors.toList());
            if (possibles.size() == 0) {
                return;
            }
            String res = possibles.size() == 1 ? (String)possibles.get(0) : (String)possibles.get(XorShiftRandom.current().nextInt(possibles.size()));
            ResourceLocation rl = new ResourceLocation(res);
            IAcoustic acoustic = Primitives.getSound(rl, Category.MASTER);
            IAcousticFactory factory = acoustic.getFactory();
            if (factory != null) {
                PlayerCenteredSoundInstance instance = new PlayerCenteredSoundInstance(acoustic.getFactory().createSound(), Category.MASTER);
                GameUtils.getMC().func_212871_a_(() -> {
                    try {
                        AudioEngine.play(instance);
                    }
                    catch (Throwable t) {
                        LOGGER.error(t, "Error executing startup sound '%s'", rl.toString());
                    }
                });
            }
        }
    }
}

