/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.scripting.sets;

import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.WorldUtils;
import org.orecruncher.lib.scripting.VariableSet;
import org.orecruncher.lib.scripting.sets.IDimensionVariables;

@OnlyIn(value=Dist.CLIENT)
public class DimensionVariables
extends VariableSet<IDimensionVariables>
implements IDimensionVariables {
    private String id;
    private String name;
    private boolean hasSky;
    private boolean isSuperFlat;

    public DimensionVariables() {
        super("dim");
    }

    @Override
    @Nonnull
    public IDimensionVariables getInterface() {
        return this;
    }

    @Override
    public void update() {
        if (GameUtils.isInGame()) {
            assert (GameUtils.getWorld() != null);
            DimensionType dim = GameUtils.getWorld().func_230315_m_();
            ResourceLocation location = GameUtils.getWorld().func_234923_W_().func_240901_a_();
            this.id = location.toString();
            this.hasSky = dim.func_218272_d();
            this.name = location.func_110623_a();
            this.isSuperFlat = WorldUtils.isSuperFlat((World)GameUtils.getWorld());
        } else {
            this.id = "UNKNOWN";
            this.hasSky = false;
            this.name = "UNKNOWN";
            this.isSuperFlat = false;
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getDimName() {
        return this.name;
    }

    @Override
    public boolean hasSky() {
        return this.hasSky;
    }

    @Override
    public boolean isSuperFlat() {
        return this.isSuperFlat;
    }
}

