/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.resource;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.orecruncher.lib.Singleton;
import org.orecruncher.lib.resource.IResourceAccessor;

@OnlyIn(value=Dist.CLIENT)
abstract class ResourceAccessorBase
implements IResourceAccessor {
    private final ResourceLocation location;
    private final Singleton<byte[]> bytes;

    public ResourceAccessorBase(@Nonnull ResourceLocation location) {
        this.location = location;
        this.bytes = new Singleton<byte[]>(this::getAsset);
    }

    @Override
    public ResourceLocation location() {
        return this.location;
    }

    @Override
    public byte[] asBytes() {
        return this.bytes.get();
    }

    @Nullable
    protected abstract byte[] getAsset();

    public String toString() {
        return this.location.toString();
    }
}

