/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.lib.biomes;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.FluidState;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ITag;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.BiomeRegistry;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.ForgeRegistries;
import org.orecruncher.environs.Environs;
import org.orecruncher.lib.GameUtils;
import org.orecruncher.lib.Localization;
import org.orecruncher.lib.gui.Color;

@OnlyIn(value=Dist.CLIENT)
public class BiomeUtilities {
    private static final Color NO_COLOR = new Color(1.0f, 1.0f, 1.0f);

    private BiomeUtilities() {
    }

    @Nonnull
    public static String getBiomeName(@Nonnull Biome biome) {
        Biome forgeBiome;
        ResourceLocation loc = biome.getRegistryName();
        if (loc == null && (forgeBiome = BiomeUtilities.getClientBiome(biome)) != null) {
            loc = forgeBiome.getRegistryName();
        }
        if (loc == null) {
            return "UNKNOWN";
        }
        String fmt = String.format("biome.%s.%s", loc.func_110624_b(), loc.func_110623_a());
        return Localization.load(fmt);
    }

    @Nonnull
    public static Collection<BiomeDictionary.Type> getBiomeTypes() {
        return BiomeDictionary.Type.getAll();
    }

    @Nonnull
    public static Color getColorForLiquid(@Nonnull IBlockReader world, @Nonnull BlockPos pos) {
        Biome biome;
        FluidState fluidState = world.func_204610_c(pos);
        if (fluidState.func_206888_e()) {
            return NO_COLOR;
        }
        Fluid fluid = fluidState.func_206886_c();
        if (fluid.func_207185_a((ITag)FluidTags.field_206959_a) && (biome = BiomeUtilities.getClientBiome(pos)) != null) {
            return new Color(biome.func_185361_o());
        }
        return new Color(fluid.getAttributes().getColor());
    }

    @Nonnull
    public static Set<BiomeDictionary.Type> getBiomeTypes(@Nonnull Biome biome) {
        try {
            Biome forgeBiome;
            ResourceLocation loc = biome.getRegistryName();
            if (loc == null && (forgeBiome = BiomeUtilities.getClientBiome(biome)) != null) {
                loc = forgeBiome.getRegistryName();
            }
            if (loc != null) {
                RegistryKey key = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239720_u_, (ResourceLocation)loc);
                return BiomeDictionary.getTypes((RegistryKey)key);
            }
        }
        catch (Throwable t) {
            String name = biome.toString();
            Environs.LOGGER.warn("Unable to get biome type data for biome '%s'", name);
        }
        return ImmutableSet.of();
    }

    @Nullable
    public static Biome getClientBiome(@Nonnull BlockPos pos) {
        ClientWorld world = GameUtils.getWorld();
        if (world == null) {
            return BiomeRegistry.field_244201_b;
        }
        Biome biome = world.func_226691_t_(pos);
        return BiomeUtilities.getClientBiome(biome);
    }

    @Nullable
    public static Biome getClientBiome(@Nonnull Biome biome) {
        ClientWorld world = GameUtils.getWorld();
        if (world == null) {
            return BiomeRegistry.field_244201_b;
        }
        ResourceLocation loc = world.func_241828_r().func_243612_b(Registry.field_239720_u_).func_177774_c((Object)biome);
        if (loc == null) {
            return BiomeRegistry.field_244201_b;
        }
        Biome result = (Biome)ForgeRegistries.BIOMES.getValue(loc);
        if (result == null) {
            return BiomeRegistry.field_244201_b;
        }
        return result;
    }
}

