/*
 * Decompiled with CFR 0.152.
 */
package org.orecruncher.environs.fog;

import javax.annotation.Nonnull;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.orecruncher.environs.config.Config;
import org.orecruncher.environs.fog.FogResult;
import org.orecruncher.environs.fog.VanillaFogRangeCalculator;
import org.orecruncher.environs.handlers.CommonState;
import org.orecruncher.environs.library.DimensionInfo;
import org.orecruncher.lib.GameUtils;

@OnlyIn(value=Dist.CLIENT)
public class HazeFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected static final int BAND_OFFSETS = 15;
    protected static final int BAND_CORE_SIZE = 10;
    protected static final float IMPACT_FAR = 0.6f;
    protected static final float IMPACT_NEAR = 0.95f;
    protected final FogResult cached = new FogResult();

    public HazeFogRangeCalculator() {
        super("HazeFogRangeCalculator");
    }

    @Override
    public boolean enabled() {
        return (Boolean)Config.CLIENT.fog.enableElevationHaze.get();
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        DimensionInfo di = CommonState.getDimensionInfo();
        if (di.hasHaze()) {
            float lowY = di.getCloudHeight() - 15;
            float highY = di.getCloudHeight() + 15 + 10;
            Vector3d eyes = GameUtils.getPlayer().func_174824_e((float)event.getRenderPartialTicks());
            if (eyes.field_72448_b > (double)lowY && eyes.field_72448_b < (double)highY) {
                float factor;
                float coreLowY = lowY + 15.0f;
                float coreHighY = coreLowY + 10.0f;
                float scaleFar = 0.6f;
                float scaleNear = 0.95f;
                if (eyes.field_72448_b < (double)coreLowY) {
                    factor = (float)((eyes.field_72448_b - (double)lowY) / 15.0);
                    scaleFar *= factor;
                    scaleNear *= factor;
                } else if (eyes.field_72448_b > (double)coreHighY) {
                    factor = (float)(((double)highY - eyes.field_72448_b) / 15.0);
                    scaleFar *= factor;
                    scaleNear *= factor;
                }
                float end = event.getFarPlaneDistance() * (1.0f - scaleFar);
                float start = event.getFarPlaneDistance() * (1.0f - scaleNear);
                this.cached.set(start, end);
                return this.cached;
            }
        }
        this.cached.set(event);
        return this.cached;
    }
}

