/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.block;

import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.config.SeasonsConfig;
import sereneseasons.season.SeasonTime;
import sereneseasons.tileentity.SeasonSensorTileEntity;

public class SeasonSensorBlock
extends ContainerBlock {
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0);
    private static final IntegerProperty SEASON = IntegerProperty.func_177719_a((String)"season", (int)0, (int)3);

    public SeasonSensorBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0))).func_206870_a((Property)SEASON, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader reader, BlockPos pos, ISelectionContext selectionContext) {
        return SHAPE;
    }

    public boolean func_220074_n(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader reader, BlockPos pos, Direction direction) {
        return (Integer)state.func_177229_b((Property)POWER);
    }

    public void updatePower(World world, BlockPos pos) {
        BlockState state = world.func_180495_p(pos);
        if (SeasonsConfig.isDimensionWhitelisted((RegistryKey<World>)world.func_234923_W_())) {
            BlockState currentState = world.func_180495_p(pos);
            int power = 0;
            int startTicks = (Integer)currentState.func_177229_b((Property)SEASON) * SeasonTime.ZERO.getSeasonDuration();
            int endTicks = ((Integer)currentState.func_177229_b((Property)SEASON) + 1) * SeasonTime.ZERO.getSeasonDuration();
            int currentTicks = SeasonHelper.getSeasonState(world).getSeasonCycleTicks();
            if (currentTicks >= startTicks && currentTicks <= endTicks) {
                float delta = (float)(currentTicks - startTicks) / (float)SeasonTime.ZERO.getSeasonDuration();
                power = (int)Math.min(delta * 15.0f + 1.0f, 15.0f);
            }
            if ((Integer)currentState.func_177229_b((Property)POWER) != power) {
                world.func_180501_a(pos, (BlockState)currentState.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(power)), 3);
            }
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        if (player.func_175142_cm()) {
            if (world.field_72995_K) {
                return ActionResultType.SUCCESS;
            }
            BlockState blockstate = (BlockState)state.func_235896_a_((Property)SEASON);
            world.func_180501_a(pos, blockstate, 4);
            this.updatePower(world, pos);
            return ActionResultType.SUCCESS;
        }
        return super.func_225533_a_(state, world, pos, player, hand, rayTraceResult);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public TileEntity func_196283_a_(IBlockReader reader) {
        return new SeasonSensorTileEntity();
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{POWER, SEASON});
    }
}

