/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.dungeon.treasure;

import net.minecraft.loot.ILootSerializer;
import net.minecraft.loot.LootFunctionType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.dungeon.treasure.function.EnchantedBook;
import xiroc.dungeoncrawl.dungeon.treasure.function.MaterialBlocks;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomItem;
import xiroc.dungeoncrawl.dungeon.treasure.function.RandomPotion;
import xiroc.dungeoncrawl.dungeon.treasure.function.Shield;
import xiroc.dungeoncrawl.dungeon.treasure.function.SuspiciousStew;

public class Treasure {
    public static final LootFunctionType ENCHANTED_BOOK = new LootFunctionType((ILootSerializer)new EnchantedBook.Serializer());
    public static final LootFunctionType MATERIAL_BLOCKS = new LootFunctionType((ILootSerializer)new MaterialBlocks.Serializer());
    public static final LootFunctionType RANDOM_ITEM = new LootFunctionType((ILootSerializer)new RandomItem.Serializer());
    public static final LootFunctionType RANDOM_POTION = new LootFunctionType((ILootSerializer)new RandomPotion.Serializer());
    public static final LootFunctionType SHIELD = new LootFunctionType((ILootSerializer)new Shield.Serializer());
    public static final LootFunctionType SUSPICIOUS_STEW = new LootFunctionType((ILootSerializer)new SuspiciousStew.Serializer());

    private static void register(ResourceLocation registryName, LootFunctionType type) {
        Registry.func_218322_a((Registry)Registry.field_239694_aZ_, (ResourceLocation)registryName, (Object)type);
    }

    public static void init() {
        Treasure.register(DungeonCrawl.locate("enchanted_book"), ENCHANTED_BOOK);
        Treasure.register(DungeonCrawl.locate("material_blocks"), MATERIAL_BLOCKS);
        Treasure.register(DungeonCrawl.locate("random_item"), RANDOM_ITEM);
        Treasure.register(DungeonCrawl.locate("random_potion"), RANDOM_POTION);
        Treasure.register(DungeonCrawl.locate("shield"), SHIELD);
        Treasure.register(DungeonCrawl.locate("suspicious_stew"), SUSPICIOUS_STEW);
    }
}

