/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacker.mixin.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mrcrayfish.backpacked.Backpacked;
import com.mrcrayfish.backpacked.client.model.ModelBackpack;
import com.mrcrayfish.backpacked.client.renderer.entity.layers.BackpackLayer;
import com.mrcrayfish.backpacked.integration.Curios;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacker.crafting.IColored;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BackpackLayer.class})
public abstract class BackpackLayerMixin {
    @Shadow(remap=false)
    private ModelBackpack model;

    @Overwrite(remap=false)
    public void render(MatrixStack stack, IRenderTypeBuffer renderTypeBuffer, int packedLightIn, PlayerEntity player, float p_225628_5_, float p_225628_6_, float red, float green, float blue, float alpha) {
        ItemStack backpack = Backpacked.getBackpackStack((PlayerEntity)player);
        if (backpack.func_77973_b() instanceof BackpackItem) {
            ItemStack chestStack = player.func_184582_a(EquipmentSlotType.CHEST);
            if (chestStack.func_77973_b() == Items.field_185160_cR) {
                return;
            }
            if (Backpacked.isCuriosLoaded() && !Curios.isBackpackVisible((PlayerEntity)player)) {
                return;
            }
            stack.func_227860_a_();
            BackpackLayer layer = (BackpackLayer)this;
            ((BipedModel)layer.func_215332_c()).func_217148_a((BipedModel)this.model);
            this.model.setupAngles((BipedModel)layer.func_215332_c());
            BackpackItem item = (BackpackItem)backpack.func_77973_b();
            if (item instanceof IColored) {
                IColored colored = (IColored)item;
                int color = colored.hasColor(backpack) ? colored.getColor(backpack) : colored.baseColor();
                float r = (float)(color >> 16 & 0xFF) / 255.0f;
                float g = (float)(color >> 8 & 0xFF) / 255.0f;
                float b = (float)(color & 0xFF) / 255.0f;
                String textureLocation = item.getModelTexture().toString();
                ResourceLocation texture = new ResourceLocation(textureLocation.substring(0, textureLocation.length() - 4) + "_overlay.png");
                IVertexBuilder overlayBuilder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)RenderType.func_239263_a_((ResourceLocation)texture), (boolean)false, (boolean)backpack.func_77962_s());
                this.model.func_225598_a_(stack, overlayBuilder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
                IVertexBuilder builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)RenderType.func_239263_a_((ResourceLocation)item.getModelTexture()), (boolean)false, (boolean)backpack.func_77962_s());
                this.model.func_225598_a_(stack, builder, packedLightIn, OverlayTexture.field_229196_a_, r, g, b, 1.0f);
            } else {
                IVertexBuilder builder = ItemRenderer.func_239391_c_((IRenderTypeBuffer)renderTypeBuffer, (RenderType)RenderType.func_239263_a_((ResourceLocation)item.getModelTexture()), (boolean)false, (boolean)backpack.func_77962_s());
                this.model.func_225598_a_(stack, builder, packedLightIn, OverlayTexture.field_229196_a_, 1.0f, 1.0f, 1.0f, 1.0f);
            }
            stack.func_227865_b_();
        }
    }
}

