/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.lib.manual;

import blusunrize.lib.manual.ManualEntry;
import blusunrize.lib.manual.ManualInstance;
import blusunrize.lib.manual.PositionedItemStack;
import blusunrize.lib.manual.SpecialManualElement;
import blusunrize.lib.manual.SplitResult;
import blusunrize.lib.manual.TextSplitter;
import blusunrize.lib.manual.Tree;
import blusunrize.lib.manual.gui.GuiButtonManualLink;
import blusunrize.lib.manual.gui.ManualScreen;
import blusunrize.lib.manual.links.Link;
import blusunrize.lib.manual.utils.ManualLogger;
import blusunrize.lib.manual.utils.ManualRenderTypes;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ITagCollection;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class ManualUtils {
    public static final String THIS = "this";
    static HashMap<String, ResourceLocation> resourceMap = new HashMap();

    public static boolean stackMatchesObject(ItemStack stack, Object o) {
        if (o instanceof ResourceLocation) {
            return ManualUtils.isInTag(stack, (ResourceLocation)o);
        }
        if (o instanceof ItemStack) {
            if (!ItemStack.func_179545_c((ItemStack)((ItemStack)o), (ItemStack)stack)) {
                return false;
            }
            if (((ItemStack)o).func_77942_o()) {
                return ((ItemStack)o).func_77978_p().equals((Object)stack.func_77978_p());
            }
            return true;
        }
        return false;
    }

    public static boolean isInTag(ItemStack stack, ResourceLocation tag) {
        ITag itemTag = ItemTags.func_199903_a().func_199910_a(tag);
        if (itemTag != null && itemTag.func_230235_a_((Object)stack.func_77973_b())) {
            return true;
        }
        ITag blockTag = BlockTags.func_199896_a().func_199910_a(tag);
        return blockTag != null && blockTag.func_230235_a_((Object)Block.func_149634_a((Item)stack.func_77973_b()));
    }

    public static boolean isNonemptyItemTag(ResourceLocation name) {
        return ManualUtils.isNonEmptyTag(ItemTags.func_199903_a(), name);
    }

    public static boolean isNonemptyBlockTag(ResourceLocation name) {
        return ManualUtils.isNonEmptyTag(BlockTags.func_199896_a(), name);
    }

    private static <T> boolean isNonEmptyTag(ITagCollection<T> collection, ResourceLocation name) {
        ITag tag = collection.func_199910_a(name);
        return tag != null && tag.func_230236_b_().size() > 0;
    }

    public static boolean isNonemptyBlockOrItemTag(ResourceLocation name) {
        return ManualUtils.isNonemptyBlockTag(name) || ManualUtils.isNonemptyItemTag(name);
    }

    public static String getTitleForNode(Tree.AbstractNode<ResourceLocation, ManualEntry> node, ManualInstance inst) {
        if (node.isLeaf()) {
            return inst.formatEntryName(node.getLeafData().getTitle());
        }
        return inst.formatCategoryName(node.getNodeData());
    }

    public static void drawTexturedRect(ResourceLocation texture, int x, int y, int w, int h, float ... uv) {
        IRenderTypeBuffer.Impl buffers = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        ManualUtils.drawTexturedRect(new MatrixStack(), (IRenderTypeBuffer)buffers, texture, x, y, w, h, uv);
        buffers.func_228461_a_();
    }

    public static void drawTexturedRect(MatrixStack transform, IRenderTypeBuffer buffers, ResourceLocation texture, int x, int y, int w, int h, float ... uv) {
        IVertexBuilder buffer = buffers.getBuffer(ManualRenderTypes.getGui(texture));
        Matrix4f mat = transform.func_227866_c_().func_227870_a_();
        buffer.func_227888_a_(mat, (float)x, (float)(y + h), 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uv[0], uv[3]).func_181675_d();
        buffer.func_227888_a_(mat, (float)(x + w), (float)(y + h), 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uv[1], uv[3]).func_181675_d();
        buffer.func_227888_a_(mat, (float)(x + w), (float)y, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uv[1], uv[2]).func_181675_d();
        buffer.func_227888_a_(mat, (float)x, (float)y, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(uv[0], uv[2]).func_181675_d();
    }

    public static <T> List<T> getPrimitiveSpellingCorrections(String query, Iterable<T> valid, int maxDistance, Function<T, String> getTitle) {
        ArrayList<Object> ret = new ArrayList<Object>();
        for (T node : valid) {
            String s2 = getTitle.apply(node);
            if (s2 == null || s2.trim().isEmpty() || ManualUtils.getSpellingDistanceBetweenStrings(query, s2) >= maxDistance) continue;
            ret.add(node);
        }
        ret.sort(Comparator.comparingInt(s -> ManualUtils.getSpellingDistanceBetweenStrings(query, (String)getTitle.apply(s))));
        return ret;
    }

    public static int getSpellingDistanceBetweenStrings(String query, String target) {
        query = query.toLowerCase(Locale.ENGLISH);
        target = target.toLowerCase(Locale.ENGLISH);
        String[] queryWords = query.split(" ");
        String[] targetWords = target.split(" ");
        int distance = 0;
        for (int iWord = 0; iWord < queryWords.length; ++iWord) {
            if (iWord >= targetWords.length) {
                ++distance;
                continue;
            }
            int wordDistance = 0;
            for (int iChar = 0; iChar < queryWords[iWord].length(); ++iChar) {
                if (iChar >= targetWords[iWord].length()) {
                    ++distance;
                    continue;
                }
                if (queryWords[iWord].charAt(iChar) == targetWords[iWord].charAt(iChar)) continue;
                ++wordDistance;
                if (iChar <= 0 || queryWords[iWord].charAt(iChar - 1) != targetWords[iWord].charAt(iChar) || queryWords[iWord].charAt(iChar) != targetWords[iWord].charAt(iChar - 1)) continue;
                wordDistance -= 2;
            }
            if (wordDistance > 0) {
                wordDistance += Math.abs(targetWords[iWord].length() - queryWords[iWord].length());
            }
            distance += wordDistance;
        }
        return distance;
    }

    public static void addLinkButtons(ManualEntry entry, ManualInstance manual, ManualScreen gui, List<List<SplitResult.Token>> text, int x, int y, List<Button> pageButtons) {
        IdentityHashMap partButtons = new IdentityHashMap();
        MutableInt lineId = new MutableInt(0);
        for (List<SplitResult.Token> line : text) {
            MutableObject textUpToHere = new MutableObject((Object)"");
            for (SplitResult.Token token : line) {
                token.getContent().ifRight(arg_0 -> ManualUtils.lambda$addLinkButtons$2(manual, (Mutable)textUpToHere, lineId, entry, gui, x, y, partButtons, arg_0));
                textUpToHere.setValue((Object)((String)textUpToHere.getValue() + token.getText()));
            }
            lineId.increment();
        }
        for (List<SplitResult.Token> parts : partButtons.values()) {
            for (GuiButtonManualLink guiButtonManualLink : parts) {
                guiButtonManualLink.otherParts = parts;
                pageButtons.add(guiButtonManualLink);
            }
        }
    }

    public static String attemptStringTranslation(String tranlationKey, String arg) {
        String translated;
        String untranslated = String.format(tranlationKey, arg);
        if (!untranslated.equals(translated = I18n.func_135052_a((String)untranslated, (Object[])new Object[0]))) {
            return translated;
        }
        return arg;
    }

    public static Tessellator tes() {
        return Tessellator.func_178181_a();
    }

    public static Minecraft mc() {
        return Minecraft.func_71410_x();
    }

    public static void bindTexture(ResourceLocation path) {
        ManualUtils.mc().func_110434_K().func_110577_a(path);
    }

    public static ResourceLocation getResource(String path) {
        ResourceLocation rl;
        ResourceLocation resourceLocation = rl = resourceMap.containsKey(path) ? resourceMap.get(path) : new ResourceLocation(path);
        if (!resourceMap.containsKey(path)) {
            resourceMap.put(path, rl);
        }
        return rl;
    }

    public static ItemRenderer renderItem() {
        return ManualUtils.mc().func_175599_af();
    }

    public static void drawSplitString(MatrixStack transform, FontRenderer fontRenderer, List<String> text, int x, int y, int colour) {
        for (String s : text) {
            fontRenderer.func_238421_b_(transform, s, (float)x, (float)y, colour);
            fontRenderer.getClass();
            y += 9;
        }
    }

    private static void parseSpecial(JsonObject obj, String anchor, TextSplitter splitter, ManualInstance instance) {
        String type = JSONUtils.func_151200_h((JsonObject)obj, (String)"type");
        int offset = JSONUtils.func_151208_a((JsonObject)obj, (String)"offset", (int)0);
        ResourceLocation resLoc = ManualUtils.getLocationForManual(type, instance);
        Function<JsonObject, SpecialManualElement> createElement = instance.getElementFactory(resLoc);
        splitter.addSpecialPage(anchor, offset, createElement.apply(obj));
    }

    public static void parseSpecials(JsonObject data, TextSplitter splitter, ManualInstance instance) {
        for (Map.Entry entry : data.entrySet()) {
            JsonElement currData = (JsonElement)entry.getValue();
            if (currData.isJsonObject()) {
                ManualUtils.parseSpecial(currData.getAsJsonObject(), (String)entry.getKey(), splitter, instance);
                continue;
            }
            for (JsonElement inner : currData.getAsJsonArray()) {
                ManualUtils.parseSpecial(inner.getAsJsonObject(), (String)entry.getKey(), splitter, instance);
            }
        }
    }

    public static ResourceLocation getLocationForManual(String s, ManualInstance instance) {
        if (s.indexOf(58) >= 0) {
            return new ResourceLocation(s);
        }
        return new ResourceLocation(instance.getDefaultResourceDomain(), s);
    }

    public static boolean isNumber(JsonObject main, String name) {
        return main.has(name) && main.get(name).isJsonPrimitive() && main.get(name).getAsJsonPrimitive().isNumber();
    }

    @Nullable
    public static PositionedItemStack parsePosItemStack(JsonElement ele) {
        JsonObject json = ele.getAsJsonObject();
        if (!ManualUtils.isNumber(json, "x")) {
            return null;
        }
        int x = JSONUtils.func_151203_m((JsonObject)json, (String)"x");
        if (!ManualUtils.isNumber(json, "y")) {
            return null;
        }
        int y = JSONUtils.func_151203_m((JsonObject)json, (String)"y");
        if (JSONUtils.func_151205_a((JsonObject)json, (String)"item")) {
            return new PositionedItemStack(CraftingHelper.getItemStack((JsonObject)json, (boolean)true), x, y);
        }
        if (JSONUtils.func_151202_d((JsonObject)json, (String)"stacks")) {
            JsonArray arr = json.getAsJsonArray("stacks");
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>(arr.size());
            for (JsonElement stack : arr) {
                stacks.add(CraftingHelper.getItemStack((JsonObject)stack.getAsJsonObject(), (boolean)true));
            }
            return new PositionedItemStack(stacks, x, y);
        }
        try {
            return new PositionedItemStack(CraftingHelper.getIngredient((JsonElement)json), x, y);
        }
        catch (JsonSyntaxException xcp) {
            return null;
        }
    }

    public static ItemStack getItemStackFromJson(ManualInstance m, JsonElement jsonEle) {
        if (jsonEle.isJsonPrimitive()) {
            ResourceLocation itemName = ManualUtils.getLocationForManual(jsonEle.getAsString(), m);
            return new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(itemName));
        }
        return CraftingHelper.getItemStack((JsonObject)jsonEle.getAsJsonObject(), (boolean)true);
    }

    public static Object getRecipeObjFromJson(ManualInstance m, JsonElement jsonEle) {
        if (jsonEle.isJsonObject()) {
            JsonObject json = jsonEle.getAsJsonObject();
            if (JSONUtils.func_151205_a((JsonObject)json, (String)"recipe")) {
                return ManualUtils.getLocationForManual(JSONUtils.func_151200_h((JsonObject)json, (String)"recipe"), m);
            }
            if (JSONUtils.func_151205_a((JsonObject)json, (String)"orename")) {
                return json.get("orename").getAsString();
            }
            if (JSONUtils.func_151205_a((JsonObject)json, (String)"item")) {
                return CraftingHelper.getItemStack((JsonObject)json, (boolean)true);
            }
        } else {
            if (jsonEle.isJsonArray()) {
                JsonArray json = jsonEle.getAsJsonArray();
                PositionedItemStack[] stacks = new PositionedItemStack[json.size()];
                for (int i = 0; i < json.size(); ++i) {
                    PositionedItemStack posStack = ManualUtils.parsePosItemStack(json.get(i));
                    if (posStack == null) {
                        throw new RuntimeException("Failed to load positional item stack from " + json.get(i));
                    }
                    stacks[i] = posStack;
                }
                return stacks;
            }
            if (jsonEle.isJsonPrimitive() && jsonEle.getAsJsonPrimitive().isString()) {
                return ManualUtils.getLocationForManual(jsonEle.getAsString(), m);
            }
        }
        throw new RuntimeException("Could not find recipe for " + jsonEle);
    }

    public static boolean listStack(String search, ItemStack stack) {
        return stack.func_200301_q().getString().toLowerCase(Locale.ENGLISH).contains(search);
    }

    public static void renderItemStack(MatrixStack transform, ItemStack stack, int x, int y, boolean overlay) {
        if (!stack.func_190926_b()) {
            RenderSystem.pushMatrix();
            RenderSystem.multMatrix((Matrix4f)transform.func_227866_c_().func_227870_a_());
            ItemRenderer itemRenderer = ManualUtils.renderItem();
            itemRenderer.field_77023_b -= 50.0f;
            itemRenderer.func_180450_b(stack, x, y);
            itemRenderer.field_77023_b += 50.0f;
            if (overlay) {
                FontRenderer font = stack.func_77973_b().getFontRenderer(stack);
                font = font != null ? font : Minecraft.func_71410_x().field_71466_p;
                itemRenderer.func_180453_a(font, stack, x, y, null);
            }
            RenderSystem.popMatrix();
        }
    }

    private static /* synthetic */ void lambda$addLinkButtons$2(ManualInstance manual, Mutable textUpToHere, MutableInt lineId, ManualEntry entry, ManualScreen gui, int x, int y, Map partButtons, SplitResult.LinkPart linkPart) {
        ManualInstance.ManualLink outputLink;
        int bx = manual.fontRenderer().func_78256_a((String)textUpToHere.getValue());
        int n = lineId.intValue();
        manual.fontRenderer().getClass();
        int by = n * 9;
        Link link = linkPart.getParent();
        String linkText = linkPart.getText();
        ResourceLocation bkey = link.getTarget(entry);
        int bw = manual.fontRenderer().func_78256_a(linkText);
        ManualEntry bEntry = manual.getEntry(bkey);
        if (bEntry != null && bEntry.hasAnchor(link.getTargetAnchor())) {
            outputLink = new ManualInstance.ManualLink(bEntry, link.getTargetAnchor(), link.getTargetOffset());
        } else {
            if (bEntry == null) {
                ManualLogger.LOGGER.error("Unknown manual entry: {} (link from {})", (Object)bkey, (Object)entry.getLocation());
            } else if (!bEntry.hasAnchor(link.getTargetAnchor())) {
                ManualLogger.LOGGER.error("Unknown anchor {} in entry {} (link from {})", (Object)link.getTargetAnchor(), (Object)bkey, (Object)entry.getLocation());
            }
            outputLink = null;
        }
        manual.fontRenderer().getClass();
        GuiButtonManualLink btn = new GuiButtonManualLink(gui, x + bx, y + by, bw, (int)(9.0 * 1.5), outputLink, linkText);
        partButtons.computeIfAbsent(link, l -> new ArrayList()).add(btn);
    }
}

