/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.api.tool.ITool;
import blusunrize.immersiveengineering.api.utils.CapabilityUtils;
import blusunrize.immersiveengineering.client.models.IOBJModelCallback;
import blusunrize.immersiveengineering.client.render.IEOBJItemRenderer;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ChemthrowerItem
extends UpgradeableToolItem
implements IEItemInterfaces.IAdvancedFluidItem,
IOBJModelCallback<ItemStack>,
ITool,
IEItemInterfaces.IScrollwheel {
    private static final int CAPACITY = 2000;

    public ChemthrowerItem() {
        super("chemthrower", new Item.Properties().setISTER(() -> () -> IEOBJItemRenderer.INSTANCE).func_200917_a(1), "CHEMTHROWER");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        int cap = this.getCapacity(stack, 2000);
        int numberOfTanks = this.getUpgrades(stack).func_74767_n("multitank") ? 3 : 1;
        for (int i = 0; i < numberOfTanks; ++i) {
            ITextComponent add = IEItemFluidHandler.fluidItemInfoFlavor(ItemNBTHelper.getFluidStack(stack, "Fluid" + (i > 0 ? Integer.valueOf(i) : "")), cap);
            if (i > 0) {
                TextUtils.applyFormat(add, TextFormatting.GRAY);
            }
            list.add(add);
        }
    }

    private ITextComponent formatFluidStack(FluidStack fs, int capacity) {
        if (fs != null) {
            FluidAttributes attr = fs.getFluid().getAttributes();
            TextFormatting rarity = attr.getRarity() == Rarity.COMMON ? TextFormatting.GRAY : attr.getRarity().field_77937_e;
            return TextUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.fluidStack", new Object[]{attr.getDisplayName(fs), fs.getAmount(), capacity}), rarity);
        }
        return new TranslationTextComponent("desc.immersiveengineering.flavour.drill.empty");
    }

    @Nonnull
    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.NONE;
    }

    @Override
    public void removeFromWorkbench(PlayerEntity player, ItemStack stack) {
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            if (!world.field_72995_K) {
                ChemthrowerItem.setIgniteEnable(stack, !ChemthrowerItem.isIgniteEnable(stack));
            }
        } else {
            player.func_184598_c(hand);
        }
        return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
    }

    public void onUsingTick(ItemStack stack, LivingEntity player, int count) {
        FluidStack fs = this.getFluid(stack);
        if (!fs.isEmpty()) {
            int duration = this.func_77626_a(stack) - count;
            int consumed = (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get();
            if (consumed * duration <= fs.getAmount()) {
                float range;
                Vector3d v = player.func_70040_Z();
                int split = 8;
                boolean isGas = fs.getFluid().getAttributes().isGaseous();
                float scatter = isGas ? 0.15f : 0.05f;
                float f = range = isGas ? 0.5f : 1.0f;
                if (this.getUpgrades(stack).func_74767_n("focus")) {
                    range += 0.25f;
                    scatter -= 0.025f;
                }
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && ChemthrowerItem.isIgniteEnable(stack);
                for (int i = 0; i < split; ++i) {
                    Vector3d vecDir = v.func_72441_c(player.func_70681_au().nextGaussian() * (double)scatter, player.func_70681_au().nextGaussian() * (double)scatter, player.func_70681_au().nextGaussian() * (double)scatter);
                    ChemthrowerShotEntity chem = new ChemthrowerShotEntity(player.field_70170_p, player, vecDir.field_72450_a * 0.25, vecDir.field_72448_b * 0.25, vecDir.field_72449_c * 0.25, fs);
                    chem.func_213317_d(player.func_213322_ci().func_178787_e(vecDir.func_186678_a((double)range)));
                    if (!player.func_233570_aj_()) {
                        player.func_213317_d(player.func_213322_ci().func_178788_d(vecDir.func_186678_a(0.0025 * (double)range)));
                    }
                    if (ignite) {
                        chem.func_70015_d(10);
                    }
                    if (player.field_70170_p.field_72995_K) continue;
                    player.field_70170_p.func_217376_c((Entity)chem);
                }
                if (count % 4 == 0) {
                    if (ignite) {
                        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), IESounds.sprayFire, SoundCategory.PLAYERS, 0.5f, 1.5f);
                    } else {
                        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), IESounds.spray, SoundCategory.PLAYERS, 0.5f, 0.75f);
                    }
                }
            } else {
                player.func_184597_cx();
            }
        } else {
            player.func_184597_cx();
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity player, int timeLeft) {
        FluidStack fs = this.getFluid(stack);
        if (!fs.isEmpty()) {
            int duration = this.func_77626_a(stack) - timeLeft;
            fs.shrink((Integer)IEServerConfig.TOOLS.chemthrower_consumption.get() * duration);
            if (fs.getAmount() <= 0) {
                ItemNBTHelper.remove(stack, "Fluid");
            } else {
                ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Override
    public void onScrollwheel(ItemStack stack, PlayerEntity playerEntity, boolean forward) {
        if (this.getUpgrades(stack).func_74767_n("multitank")) {
            CompoundNBT fluidTag = ItemNBTHelper.getTagCompound(stack, "Fluid");
            CompoundNBT fluidTag1 = ItemNBTHelper.getTagCompound(stack, "Fluid1");
            CompoundNBT fluidTag2 = ItemNBTHelper.getTagCompound(stack, "Fluid2");
            if (forward) {
                ItemNBTHelper.setTagCompound(stack, "Fluid", fluidTag2);
                ItemNBTHelper.setTagCompound(stack, "Fluid1", fluidTag);
                ItemNBTHelper.setTagCompound(stack, "Fluid2", fluidTag1);
            } else {
                ItemNBTHelper.setTagCompound(stack, "Fluid", fluidTag1);
                ItemNBTHelper.setTagCompound(stack, "Fluid1", fluidTag2);
                ItemNBTHelper.setTagCompound(stack, "Fluid2", fluidTag);
            }
        }
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        FluidStack fs = this.getFluid(stack);
        if (!fs.isEmpty() && fs.getAmount() > this.getCapacity(stack, 2000)) {
            fs.setAmount(this.getCapacity(stack, 2000));
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        if ("base".equals(group) || "grip".equals(group) || "cage".equals(group) || "tanks".equals(group)) {
            return true;
        }
        CompoundNBT upgrades = this.getUpgrades(stack);
        if ("large_tank".equals(group) && upgrades.func_74762_e("capacity") > 0) {
            return true;
        }
        if ("multi_tank".equals(group) && upgrades.func_74767_n("multitank")) {
            return true;
        }
        return "tank".equals(group);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged) {
            return true;
        }
        LazyOptional wrapperOld = oldStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
        Optional sameShader = wrapperOld.map(wOld -> {
            LazyOptional wrapperNew = newStack.getCapability(CapabilityShader.SHADER_CAPABILITY);
            return wrapperNew.map(w -> ItemStack.func_77989_b((ItemStack)wOld.getShaderItem(), (ItemStack)w.getShaderItem())).orElse(true);
        });
        if (!sameShader.orElse(true).booleanValue()) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    @Override
    public ICapabilityProvider initCapabilities(final ItemStack stack, CompoundNBT nbt) {
        if (!stack.func_190926_b()) {
            return new IEItemStackHandler(stack){
                LazyOptional<IEItemFluidHandler> fluids;
                LazyOptional<CapabilityShader.ShaderWrapper_Item> shaders;
                {
                    super(stack2);
                    this.fluids = CapabilityUtils.constantOptional(new IEItemFluidHandler(stack, 2000));
                    this.shaders = CapabilityUtils.constantOptional(new CapabilityShader.ShaderWrapper_Item(new ResourceLocation("immersiveengineering", "chemthrower"), stack));
                }

                @Override
                @Nonnull
                public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, Direction facing) {
                    if (capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY) {
                        return this.fluids.cast();
                    }
                    if (capability == CapabilityShader.SHADER_CAPABILITY) {
                        return this.shaders.cast();
                    }
                    return super.getCapability(capability, facing);
                }
            };
        }
        return null;
    }

    @Override
    public int getSlotCount() {
        return 4;
    }

    @Override
    public int getCapacity(ItemStack stack, int baseCapacity) {
        return baseCapacity + this.getUpgrades(stack).func_74762_e("capacity");
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, Supplier<World> getWorld, Supplier<PlayerEntity> getPlayer) {
        LazyOptional inv = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        return new Slot[]{new IESlot.Upgrades(container, (IItemHandler)inv.orElseThrow(RuntimeException::new), 0, 80, 32, "CHEMTHROWER", stack, true, getWorld, getPlayer), new IESlot.Upgrades(container, (IItemHandler)inv.orElseThrow(RuntimeException::new), 1, 100, 32, "CHEMTHROWER", stack, true, getWorld, getPlayer)};
    }

    @Override
    public boolean isTool(ItemStack item) {
        return true;
    }

    public static void setIgniteEnable(ItemStack chemthrower, boolean enabled) {
        chemthrower.func_196082_o().func_74757_a("ignite", enabled);
    }

    public static boolean isIgniteEnable(ItemStack chemthrower) {
        return ItemNBTHelper.getBoolean(chemthrower, "ignite");
    }
}

