/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.render.IEOBJItemRenderer;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.DieselToolItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.IEItems;
import blusunrize.immersiveengineering.common.items.SawbladeItem;
import blusunrize.immersiveengineering.common.items.ToolUpgradeItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.fluids.IEItemFluidHandler;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.state.Property;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.SlotItemHandler;

public class BuzzsawItem
extends DieselToolItem
implements IEItemInterfaces.IScrollwheel {
    public static final Collection<SawbladeItem> SAWBLADES = new ArrayList<SawbladeItem>(2);
    private static final int MAX_HORIZONTAL_DISTANCE = 7;
    private static final String[][] GROUP_BLADE = new String[][]{{"blade"}};
    @OnlyIn(value=Dist.CLIENT)
    private static TransformationMatrix MAT_FIXED;

    public BuzzsawItem() {
        super("buzzsaw", BuzzsawItem.withIEOBJRender().func_200917_a(1).setISTER(() -> () -> IEOBJItemRenderer.INSTANCE), "BUZZSAW");
    }

    @Override
    public int getSlotCount() {
        return 5;
    }

    @Override
    public Slot[] getWorkbenchSlots(Container container, ItemStack stack, Supplier<World> getWorld, Supplier<PlayerEntity> getPlayer) {
        IItemHandler inv = (IItemHandler)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(RuntimeException::new);
        boolean hasQuiver = BuzzsawItem.hasQuiverUpgrade(stack);
        int mainHeadX = hasQuiver ? 88 : 98;
        ArrayList<SlotItemHandler> slots = new ArrayList<SlotItemHandler>(5);
        slots.add(new IESlot.WithPredicate(inv, 0, mainHeadX, 22, BuzzsawItem::isSawblade, newBlade -> this.setHead(stack, (ItemStack)newBlade)));
        slots.add(new IESlot.Upgrades(container, inv, 1, 88, 52, "BUZZSAW", stack, true, getWorld, getPlayer));
        slots.add(new IESlot.Upgrades(container, inv, 2, 108, 52, "BUZZSAW", stack, true, getWorld, getPlayer));
        if (BuzzsawItem.hasQuiverUpgrade(stack)) {
            slots.add(new IESlot.WithPredicate(inv, 3, 108, 12, BuzzsawItem::isSawblade));
            slots.add(new IESlot.WithPredicate(inv, 4, 108, 32, BuzzsawItem::isSawblade));
        }
        return slots.toArray(new Slot[0]);
    }

    @Override
    public ItemStack removeUpgrade(ItemStack stack, PlayerEntity player, ItemStack upgrade) {
        if (upgrade.func_77973_b() == IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.BUZZSAW_SPAREBLADES)) {
            for (int i = 1; i <= 2; ++i) {
                ItemStack sawblade = this.getSawblade(stack, i);
                if (sawblade.func_190926_b()) continue;
                ItemNBTHelper.setItemStack(upgrade, "sawblade" + i, sawblade);
                this.setSawblade(stack, ItemStack.field_190927_a, i);
            }
        }
        return upgrade;
    }

    @Override
    public void removeFromWorkbench(PlayerEntity player, ItemStack stack) {
        LazyOptional invCap = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        invCap.ifPresent(inv -> {
            if (!(inv.getStackInSlot(0).func_190926_b() || inv.getStackInSlot(1).func_190926_b() || inv.getStackInSlot(2).func_190926_b())) {
                Utils.unlockIEAdvancement(player, "main/upgrade_buzzsaw");
            }
        });
    }

    @Override
    public void recalculateUpgrades(ItemStack stack, World w, PlayerEntity player) {
        super.recalculateUpgrades(stack, w, player);
        LazyOptional invCap = stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        invCap.ifPresent(inv -> {
            for (int iUpgrade = 1; iUpgrade <= 2; ++iUpgrade) {
                ItemStack upgrade = inv.getStackInSlot(iUpgrade);
                if (upgrade.func_77973_b() != IEItems.Misc.toolUpgrades.get((Object)ToolUpgradeItem.ToolUpgrade.BUZZSAW_SPAREBLADES)) continue;
                for (int i = 1; i <= 2; ++i) {
                    if (!ItemNBTHelper.hasKey(upgrade, "sawblade" + i)) continue;
                    ItemStack sawblade = ItemNBTHelper.getItemStack(upgrade, "sawblade" + i);
                    this.setSawblade(stack, sawblade, i);
                    ItemNBTHelper.remove(upgrade, "sawblade" + i);
                }
            }
        });
    }

    @Override
    public ItemStack getHead(ItemStack itemStack) {
        return this.getSawblade(itemStack, 0);
    }

    public ItemStack getSawblade(ItemStack itemStack, int spare) {
        if (CapabilityItemHandler.ITEM_HANDLER_CAPABILITY == null) {
            return ItemStack.field_190927_a;
        }
        LazyOptional cap = itemStack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        int slot = spare == 0 ? 0 : 2 + spare;
        ItemStack sawblade = ((IItemHandler)cap.orElseThrow(RuntimeException::new)).getStackInSlot(slot);
        return !sawblade.func_190926_b() && BuzzsawItem.isSawblade(sawblade) ? sawblade : ItemStack.field_190927_a;
    }

    @Override
    public void setHead(ItemStack buzzsaw, ItemStack sawblade) {
        this.setSawblade(buzzsaw, sawblade, 0);
    }

    public void setSawblade(ItemStack buzzsaw, ItemStack sawblade, int spare) {
        int slot = spare == 0 ? 0 : 2 + spare;
        IItemHandler inv = (IItemHandler)buzzsaw.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null).orElseThrow(RuntimeException::new);
        ((IItemHandlerModifiable)inv).setStackInSlot(slot, sawblade);
        if (spare == 0) {
            ListNBT enchants = null;
            if (sawblade.func_77973_b() instanceof SawbladeItem) {
                enchants = ((SawbladeItem)sawblade.func_77973_b()).getSawbladeEnchants();
            }
            if (enchants != null) {
                buzzsaw.func_196082_o().func_218657_a("Enchantments", (INBT)enchants);
            } else {
                buzzsaw.func_196082_o().func_82580_o("Enchantments");
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<ITextComponent> list, ITooltipFlag flag) {
        list.add(IEItemFluidHandler.fluidItemInfoFlavor(this.getFluid(stack), this.getCapacity(stack, 2000)));
        if (this.getHead(stack).func_190926_b()) {
            list.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.buzzsaw.noBlade"), TextFormatting.GRAY));
        } else {
            int maxDmg = this.getMaxHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            TextFormatting status = (double)quote < 0.1 ? TextFormatting.RED : ((double)quote < 0.3 ? TextFormatting.GOLD : ((double)quote < 0.6 ? TextFormatting.YELLOW : TextFormatting.GREEN));
            list.add((ITextComponent)TextUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.flavour.buzzsaw.bladeDamage"), TextFormatting.GRAY).func_240702_b_(" ").func_230529_a_((ITextComponent)TextUtils.applyFormat((ITextComponent)new TranslationTextComponent("desc.immersiveengineering.info.percent", new Object[]{(int)(quote * 100.0f)}), status)));
        }
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.COMMON;
    }

    @Override
    protected double getAttackDamage(ItemStack stack, ItemStack sawblade) {
        return ((SawbladeItem)sawblade.func_77973_b()).getSawbladeDamage();
    }

    @Override
    public void onScrollwheel(ItemStack stack, PlayerEntity playerEntity, boolean forward) {
        if (BuzzsawItem.hasQuiverUpgrade(stack)) {
            ItemStack sawblade = this.getHead(stack);
            ItemStack spare1 = this.getSawblade(stack, 1);
            ItemStack spare2 = this.getSawblade(stack, 2);
            if (forward) {
                this.setHead(stack, spare2);
                this.setSawblade(stack, sawblade, 1);
                this.setSawblade(stack, spare1, 2);
            } else {
                this.setHead(stack, spare1);
                this.setSawblade(stack, spare2, 1);
                this.setSawblade(stack, sawblade, 2);
            }
        }
    }

    @Override
    public boolean canToolBeUsed(ItemStack stack, @Nullable LivingEntity player) {
        if (this.getHeadDamage(stack) >= this.getMaxHeadDamage(stack)) {
            return false;
        }
        return !this.getFluid(stack).isEmpty();
    }

    @Override
    public int getMaxHeadDamage(ItemStack stack) {
        ItemStack sawblade = this.getHead(stack);
        return !sawblade.func_190926_b() ? sawblade.func_77958_k() : 0;
    }

    @Override
    public int getHeadDamage(ItemStack stack) {
        ItemStack sawblade = this.getHead(stack);
        return !sawblade.func_190926_b() ? sawblade.func_77952_i() : 0;
    }

    public boolean func_179218_a(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity living) {
        this.consumeDurability(stack, world, state, pos, living);
        if (!world.field_72995_K && !living.func_225608_bj_() && living instanceof ServerPlayerEntity && this.canFellTree(stack) && this.canToolBeUsed(stack, living) && this.isTree(world, pos)) {
            this.fellTree(world, pos, (ServerPlayerEntity)living, stack);
        }
        return true;
    }

    @Override
    protected void damageHead(ItemStack head, int amount, LivingEntity living) {
        head.func_222118_a(amount, living, entity -> entity.func_213334_d(Hand.MAIN_HAND));
    }

    @Override
    protected void consumeDurability(ItemStack stack, World world, @Nullable BlockState state, @Nullable BlockPos pos, LivingEntity living) {
        if (state == null || !state.func_235714_a_((ITag)BlockTags.field_206952_E) || Utils.RAND.nextInt(10) == 0) {
            super.consumeDurability(stack, world, state, pos, living);
        }
    }

    public int getHarvestLevel(ItemStack stack, @Nonnull ToolType tool, @Nullable PlayerEntity player, @Nullable BlockState blockState) {
        ItemStack sawblade = this.getHead(stack);
        if (!sawblade.func_190926_b()) {
            return 3;
        }
        return -1;
    }

    public Set<ToolType> getToolTypes(ItemStack stack) {
        if (!this.getHead(stack).func_190926_b() && this.canToolBeUsed(stack, null)) {
            return ImmutableSet.of((Object)ToolType.AXE);
        }
        return super.getToolTypes(stack);
    }

    @Override
    public boolean isEffective(ItemStack stack, Material mat) {
        Material[] validMaterials = null;
        ItemStack sawblade = this.getHead(stack);
        if (sawblade.func_77973_b() instanceof SawbladeItem) {
            validMaterials = ((SawbladeItem)sawblade.func_77973_b()).getSawbladeMaterials();
        }
        if (validMaterials != null) {
            for (Material m : validMaterials) {
                if (m != mat) continue;
                return true;
            }
        }
        return false;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        ItemStack sawblade;
        if (this.isEffective(stack, state.func_185904_a()) && !(sawblade = this.getHead(stack)).func_190926_b() && this.canToolBeUsed(stack, null)) {
            return ((SawbladeItem)sawblade.func_77973_b()).getSawbladeSpeed();
        }
        return super.func_150893_a(stack, state);
    }

    private boolean isTree(World world, BlockPos initialPos) {
        int logs = 0;
        boolean leafTop = false;
        BlockPos pos = initialPos;
        for (int y = 0; y < 32; ++y) {
            BlockState state = world.func_180495_p(pos = pos.func_177984_a());
            if (state.func_235714_a_((ITag)BlockTags.field_200031_h)) {
                ++logs;
                continue;
            }
            if (state.func_235714_a_((ITag)BlockTags.field_206952_E)) {
                leafTop = true;
            }
            boolean foundLog = false;
            if (!leafTop) {
                boolean loop = true;
                for (int z = -1; z <= 1 && loop; ++z) {
                    for (int x = -1; x <= 1 && loop; ++x) {
                        state = world.func_180495_p(pos.func_177982_a(x, 0, z));
                        if (!state.func_235714_a_((ITag)BlockTags.field_200031_h)) continue;
                        pos = pos.func_177982_a(x, 0, z);
                        foundLog = true;
                        ++logs;
                        loop = false;
                    }
                }
            }
            if (!foundLog) break;
        }
        return logs >= 3 && leafTop;
    }

    private boolean canFellTree(ItemStack stack) {
        ItemStack sawblade = this.getHead(stack);
        if (sawblade.func_77973_b() instanceof SawbladeItem) {
            return ((SawbladeItem)sawblade.func_77973_b()).canSawbladeFellTree();
        }
        return false;
    }

    private boolean fellTree(final World world, BlockPos initialPos, final ServerPlayerEntity player, final ItemStack stack) {
        int logs = 0;
        ArrayDeque<BlockPos> openList = new ArrayDeque<BlockPos>();
        final ArrayDeque<BlockPos> closedList = new ArrayDeque<BlockPos>();
        openList.add(initialPos);
        while (!openList.isEmpty() && closedList.size() < 512 && logs < 256) {
            BlockPos next = (BlockPos)openList.pollFirst();
            if (Math.abs(next.func_177958_n() - initialPos.func_177958_n()) > 7 || Math.abs(next.func_177952_p() - initialPos.func_177952_p()) > 7 || closedList.contains(next)) continue;
            BlockState state = world.func_180495_p(next);
            if (state.func_235714_a_((ITag)BlockTags.field_200031_h)) {
                closedList.add(next);
                ++logs;
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        for (int x = -1; x <= 1; ++x) {
                            openList.add(next.func_177982_a(x, y, z));
                        }
                    }
                }
                continue;
            }
            if (!state.func_235714_a_((ITag)BlockTags.field_206952_E)) continue;
            closedList.add(next);
            int trunkDist = state.func_177230_c() instanceof LeavesBlock ? (Integer)state.func_177229_b((Property)LeavesBlock.field_208494_a) : 0;
            for (Direction dir : new Direction[]{Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST}) {
                BlockPos adj = next.func_177972_a(dir);
                BlockState adjState = world.func_180495_p(adj);
                if (adjState.func_235714_a_((ITag)BlockTags.field_206952_E)) {
                    int adjDist;
                    int n = adjDist = adjState.func_177230_c() instanceof LeavesBlock ? (Integer)adjState.func_177229_b((Property)LeavesBlock.field_208494_a) : 0;
                    if (adjDist < trunkDist) continue;
                }
                openList.add(adj);
            }
        }
        if (closedList.size() == 0) {
            return false;
        }
        MinecraftForge.EVENT_BUS.register(new Object(){

            @SubscribeEvent
            public void onTick(TickEvent.WorldTickEvent event) {
                if (event.phase == TickEvent.Phase.START && event.world == world) {
                    BuzzsawItem.this.breakFromList(closedList, 5, world, player, stack);
                    if (closedList.isEmpty()) {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            }
        });
        return true;
    }

    private void breakFromList(Deque<BlockPos> closedList, int maxAmount, World world, ServerPlayerEntity player, ItemStack stack) {
        int count = 0;
        while (count++ < maxAmount && !closedList.isEmpty()) {
            BlockState state;
            Block block;
            BlockPos pos = closedList.pollFirst();
            int xpDropEvent = ForgeHooks.onBlockBreakEvent((World)world, (GameType)player.field_71134_c.func_73081_b(), (ServerPlayerEntity)player, (BlockPos)pos);
            if (xpDropEvent < 0 || (block = (state = world.func_180495_p(pos)).func_177230_c()).isAir(state, (IBlockReader)world, pos) || state.func_185903_a((PlayerEntity)player, (IBlockReader)world, pos) == 0.0f) continue;
            if (player.field_71075_bZ.field_75098_d) {
                block.func_176208_a(world, pos, state, (PlayerEntity)player);
                if (block.removedByPlayer(state, world, pos, (PlayerEntity)player, false, state.func_204520_s())) {
                    block.func_176206_d((IWorld)world, pos, state);
                }
            } else {
                block.func_176208_a(world, pos, state, (PlayerEntity)player);
                TileEntity te = world.func_175625_s(pos);
                this.consumeDurability(stack, world, state, pos, (LivingEntity)player);
                if (block.removedByPlayer(state, world, pos, (PlayerEntity)player, true, state.func_204520_s())) {
                    block.func_176206_d((IWorld)world, pos, state);
                    block.func_180657_a(world, (PlayerEntity)player, pos, state, te, stack);
                    if (world instanceof ServerWorld) {
                        block.func_180637_b((ServerWorld)world, pos, xpDropEvent);
                    }
                }
            }
            world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
            player.field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite getTextureReplacement(ItemStack stack, String group, String material) {
        ResourceLocation rl;
        int spare;
        ItemStack sawblade;
        if ("blade".equals(material) && (sawblade = this.getSawblade(stack, spare = "upgrade_blades1".equals(group) ? 1 : ("upgrade_blades2".equals(group) ? 2 : 0))).func_77973_b() instanceof SawbladeItem && (rl = ((SawbladeItem)sawblade.func_77973_b()).getSawbladeTexture()) != null) {
            return ClientUtils.getSprite(rl);
        }
        return null;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean shouldRenderGroup(ItemStack stack, String group) {
        if ("body".equals(group)) {
            return true;
        }
        if ("blade".equals(group)) {
            return !this.getHead(stack).func_190926_b();
        }
        CompoundNBT upgrades = this.getUpgrades(stack);
        if ("upgrade_lube".equals(group)) {
            return upgrades.func_74767_n("oiled");
        }
        if ("upgrade_launcher".equals(group)) {
            return upgrades.func_74767_n("launcher");
        }
        if ("upgrade_blades0".equals(group)) {
            return BuzzsawItem.hasQuiverUpgrade(stack);
        }
        if ("upgrade_blades1".equals(group)) {
            return BuzzsawItem.hasQuiverUpgrade(stack) && !this.getSawblade(stack, 1).func_190926_b();
        }
        if ("upgrade_blades2".equals(group)) {
            return BuzzsawItem.hasQuiverUpgrade(stack) && !this.getSawblade(stack, 2).func_190926_b();
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix applyTransformations(ItemStack stack, String group, TransformationMatrix transform) {
        return transform;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public String[][] getSpecialGroups(ItemStack stack, ItemCameraTransforms.TransformType transform, LivingEntity entity) {
        return GROUP_BLADE;
    }

    @Override
    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public TransformationMatrix getTransformForGroups(ItemStack stack, String[] groups, ItemCameraTransforms.TransformType transform, LivingEntity entity, float partialTicks) {
        if (MAT_FIXED == null) {
            MAT_FIXED = new TransformationMatrix(new Vector3f(0.60945f, 0.0f, 0.0f), null, null, null);
        }
        if (!this.shouldRotate(entity, stack, transform)) {
            return MAT_FIXED;
        }
        float ticksPerRotation = 10.0f;
        float angle = ((float)entity.field_70173_aa % ticksPerRotation + partialTicks) / ticksPerRotation * ((float)Math.PI * 2);
        return new TransformationMatrix(new Vector3f(0.60945f, 0.0f, 0.0f), new Quaternion(0.0f, angle, 0.0f, false), null, null);
    }

    public static boolean hasQuiverUpgrade(ItemStack stack) {
        return ((BuzzsawItem)IEItems.Tools.buzzsaw).getUpgrades(stack).func_74767_n("spareblades");
    }

    public static boolean isSawblade(ItemStack stack) {
        Item item = stack.func_77973_b();
        return item instanceof SawbladeItem && SAWBLADES.contains(item);
    }
}

