/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.entities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.common.entities.IEProjectileEntity;
import blusunrize.immersiveengineering.common.network.MessageBirthdayParty;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.Utils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.network.PacketDistributor;

public class RevolvershotEntity
extends IEProjectileEntity {
    public static final EntityType<RevolvershotEntity> TYPE = EntityType.Builder.func_220322_a(RevolvershotEntity::new, (EntityClassification)EntityClassification.MISC).func_220321_a(0.125f, 0.125f).func_206830_a("immersiveengineering:revolver_shot");
    private BulletHandler.IBullet bulletType;
    public boolean bulletElectro = false;
    public ItemStack bulletPotion = ItemStack.field_190927_a;
    private float gravity;
    private float movementDecay;

    public RevolvershotEntity(EntityType<? extends RevolvershotEntity> type, World world) {
        super(type, world);
    }

    public RevolvershotEntity(World world) {
        this((EntityType<? extends RevolvershotEntity>)TYPE, world);
    }

    public RevolvershotEntity(EntityType<? extends RevolvershotEntity> eType, World world, LivingEntity shooter, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        super(eType, world, shooter, x, y, z, ax, ay, az);
        this.func_70107_b(x, y, z);
        this.bulletType = type;
    }

    public RevolvershotEntity(World world, double x, double y, double z, double ax, double ay, double az, BulletHandler.IBullet type) {
        this(TYPE, world, null, x, y, z, ax, ay, az, type);
    }

    public RevolvershotEntity(World world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type) {
        this(TYPE, world, living, ax, ay, az, type);
    }

    public RevolvershotEntity(World world, LivingEntity living, double ax, double ay, double az, ResourceLocation type) {
        this(TYPE, world, living, ax, ay, az, BulletHandler.getBullet(type));
    }

    public RevolvershotEntity(EntityType<? extends RevolvershotEntity> eType, World world, LivingEntity living, double ax, double ay, double az, BulletHandler.IBullet type) {
        this(eType, world, living, living.func_226277_ct_() + ax, living.func_226278_cu_() + (double)living.func_70047_e() + ay, living.func_226281_cx_() + az, ax, ay, az, type);
        this.setShooterSynced();
        this.func_213317_d(Vector3d.field_186680_a);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return distance < (d1 *= 64.0) * d1;
    }

    @Override
    public void func_70227_a(RayTraceResult mop) {
        Entity hitEntity;
        boolean headshot = false;
        if (mop instanceof EntityRayTraceResult && (hitEntity = ((EntityRayTraceResult)mop).func_216348_a()) instanceof LivingEntity) {
            headshot = Utils.isVecInEntityHead((LivingEntity)hitEntity, this.func_213303_ch());
        }
        if (this.bulletType != null) {
            this.bulletType.onHitTarget(this.field_70170_p, mop, this.shooterUUID, (Entity)this, headshot);
            if (mop instanceof EntityRayTraceResult) {
                hitEntity = ((EntityRayTraceResult)mop).func_216348_a();
                if (this.shooterUUID != null && headshot && hitEntity instanceof LivingEntity && ((LivingEntity)hitEntity).func_70631_g_() && ((LivingEntity)hitEntity).func_110143_aJ() <= 0.0f) {
                    PlayerEntity shooter = this.field_70170_p.func_217371_b(this.shooterUUID);
                    if (shooter != null) {
                        Utils.unlockIEAdvancement(shooter, "main/secret_birthdayparty");
                    }
                    this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), IESounds.birthdayParty, SoundCategory.PLAYERS, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                    ImmersiveEngineering.packetHandler.send(PacketDistributor.TRACKING_ENTITY.with(() -> hitEntity), (Object)new MessageBirthdayParty((LivingEntity)hitEntity));
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            this.secondaryImpact(mop);
        }
        if (mop instanceof BlockRayTraceResult) {
            this.onHitBlock((BlockRayTraceResult)mop);
        }
        this.func_70106_y();
    }

    public void secondaryImpact(RayTraceResult mop) {
        if (!(mop instanceof EntityRayTraceResult)) {
            return;
        }
        Entity hitEntity = ((EntityRayTraceResult)mop).func_216348_a();
        if (this.bulletElectro && hitEntity instanceof LivingEntity && this.shooterUUID != null) {
            PlayerEntity shooter = this.field_70170_p.func_217371_b(this.shooterUUID);
            float percentualDrain = 0.15f / (float)(this.bulletType == null ? 1 : this.bulletType.getProjectileCount(shooter));
            ((LivingEntity)hitEntity).func_195064_c(new EffectInstance(Effects.field_76421_d, 15, 4));
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                int actualDrain;
                ItemStack stack = ((LivingEntity)hitEntity).func_184582_a(slot);
                if (!EnergyHelper.isFluxReceiver((ICapabilityProvider)stack) || EnergyHelper.getEnergyStored((ICapabilityProvider)stack) <= 0) continue;
                int drain = (int)Math.max((float)EnergyHelper.getEnergyStored((ICapabilityProvider)stack), (float)EnergyHelper.getMaxEnergyStored((ICapabilityProvider)stack) * percentualDrain);
                for (int hasDrained = 0; hasDrained < drain && (actualDrain = EnergyHelper.forceExtractFlux(stack, drain, false)) > 0; hasDrained += actualDrain) {
                }
            }
        }
    }

    public void onExpire() {
    }

    protected float getMotionFactor() {
        return 0.95f;
    }

    @Override
    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74774_a("inGround", (byte)(this.field_70254_i ? 1 : 0));
        nbt.func_74778_a("bulletType", BulletHandler.findRegistryName(this.bulletType).toString());
        if (!this.bulletPotion.func_190926_b()) {
            nbt.func_218657_a("bulletPotion", (INBT)this.bulletPotion.func_77955_b(new CompoundNBT()));
        }
    }

    @Override
    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.bulletType = BulletHandler.getBullet(new ResourceLocation(nbt.func_74779_i("bulletType")));
        if (nbt.func_150297_b("bulletPotion", 10)) {
            this.bulletPotion = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("bulletPotion"));
        }
    }

    public float func_70111_Y() {
        return 1.0f;
    }

    public float func_70013_c() {
        return 1.0f;
    }

    public boolean func_70067_L() {
        return false;
    }

    @Override
    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public void setGravity(float gravity) {
        this.gravity = gravity;
    }

    @Override
    public double getGravity() {
        return this.gravity;
    }

    public void setMovementDecay(float movementDecay) {
        this.movementDecay = movementDecay;
    }

    @Override
    protected float getMotionDecayFactor() {
        return this.movementDecay;
    }

    static {
        TYPE.setRegistryName("immersiveengineering", "revolvershot");
    }
}

