/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.crafting.serializers;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.crafting.FermenterRecipe;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import blusunrize.immersiveengineering.api.crafting.IngredientWithSize;
import blusunrize.immersiveengineering.common.blocks.IEBlocks;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FermenterRecipeSerializer
extends IERecipeSerializer<FermenterRecipe> {
    @Override
    public ItemStack getIcon() {
        return new ItemStack((IItemProvider)IEBlocks.Multiblocks.fermenter);
    }

    @Override
    public FermenterRecipe readFromJson(ResourceLocation recipeId, JsonObject json) {
        FluidStack fluidOutput = FluidStack.EMPTY;
        if (json.has("fluid")) {
            fluidOutput = ApiUtils.jsonDeserializeFluidStack(JSONUtils.func_152754_s((JsonObject)json, (String)"fluid"));
        }
        ItemStack itemOutput = ItemStack.field_190927_a;
        if (json.has("result")) {
            itemOutput = this.readOutput(json.get("result"));
        }
        IngredientWithSize input = IngredientWithSize.deserialize(json.get("input"));
        int energy = JSONUtils.func_151203_m((JsonObject)json, (String)"energy");
        return IEServerConfig.MACHINES.fermenterConfig.apply(new FermenterRecipe(recipeId, fluidOutput, itemOutput, input, energy));
    }

    @Nullable
    public FermenterRecipe read(ResourceLocation recipeId, PacketBuffer buffer) {
        FluidStack fluidOutput = buffer.readFluidStack();
        ItemStack itemOutput = buffer.func_150791_c();
        IngredientWithSize input = IngredientWithSize.read(buffer);
        int energy = buffer.readInt();
        return new FermenterRecipe(recipeId, fluidOutput, itemOutput, input, energy);
    }

    public void write(PacketBuffer buffer, FermenterRecipe recipe) {
        buffer.writeFluidStack(recipe.fluidOutput);
        buffer.func_150788_a(recipe.itemOutput);
        recipe.input.write(buffer);
        buffer.writeInt(recipe.getTotalProcessEnergy());
    }
}

