/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.split;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.utils.ResettableLazy;
import blusunrize.immersiveengineering.client.models.split.AbstractSplitModel;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class BakedBasicSplitModel
extends AbstractSplitModel<IBakedModel> {
    private static final Set<BakedBasicSplitModel> WEAK_INSTANCES = Collections.newSetFromMap(new WeakHashMap());
    private final ResettableLazy<Map<Vector3i, List<BakedQuad>>> splitModels = new ResettableLazy(() -> {
        List quads = base.getQuads(null, null, Utils.RAND, (IModelData)EmptyModelData.INSTANCE);
        return this.split(quads, parts, transform);
    });

    public BakedBasicSplitModel(IBakedModel base, Set<Vector3i> parts, IModelTransform transform, Vector3i size) {
        super(base, size);
        WEAK_INSTANCES.add(this);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockPos offset = (BlockPos)extraData.getData(IEProperties.Model.SUBMODEL_OFFSET);
        if (offset != null) {
            return this.splitModels.get().getOrDefault(offset, (List<BakedQuad>)ImmutableList.of());
        }
        return this.base.getQuads(state, side, rand, extraData);
    }

    static {
        IEApi.renderCacheClearers.add(() -> WEAK_INSTANCES.forEach(b -> b.splitModels.reset()));
    }
}

