/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.wires;

import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.WireLogger;
import blusunrize.immersiveengineering.api.wires.localhandlers.ILocalHandlerProvider;
import blusunrize.immersiveengineering.api.wires.localhandlers.IWorldTickable;
import blusunrize.immersiveengineering.api.wires.localhandlers.LocalNetworkHandler;
import blusunrize.immersiveengineering.api.wires.proxy.IICProxyProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multiset;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class LocalWireNetwork
implements IWorldTickable {
    private final IICProxyProvider proxyProvider;
    private final Map<ConnectionPoint, Collection<Connection>> connections = new HashMap<ConnectionPoint, Collection<Connection>>();
    private final Map<BlockPos, IImmersiveConnectable> connectors = new HashMap<BlockPos, IImmersiveConnectable>();
    private final Map<ResourceLocation, LocalNetworkHandler> handlers = new Object2ObjectArrayMap();
    final Map<ResourceLocation, Multiset<ILocalHandlerProvider>> handlerUsers = new HashMap<ResourceLocation, Multiset<ILocalHandlerProvider>>();
    private List<Runnable> runNextTick = new ArrayList<Runnable>();
    private boolean isValid = true;
    private int version = 0;

    public LocalWireNetwork(CompoundNBT subnet, GlobalWireNetwork globalNet) {
        this(globalNet);
        ListNBT proxies = subnet.func_150295_c("proxies", 10);
        for (INBT b : proxies) {
            IImmersiveConnectable proxy = this.proxyProvider.fromNBT(((CompoundNBT)b).func_74775_l("proxy"));
            for (INBT p : ((CompoundNBT)b).func_150295_c("points", 10)) {
                ConnectionPoint point = new ConnectionPoint((CompoundNBT)p);
                this.addConnector(point, proxy, globalNet);
            }
        }
        ListNBT wires = subnet.func_150295_c("wires", 10);
        for (INBT b : wires) {
            Connection wire = new Connection((CompoundNBT)b);
            if (this.connectors.containsKey(wire.getEndA().getPosition()) && this.connectors.containsKey(wire.getEndB().getPosition())) {
                this.addConnection(wire, globalNet);
                continue;
            }
            WireLogger.logger.error("Wire from {} to {}, but connector points are {}", (Object)wire.getEndA(), (Object)wire.getEndB(), this.connectors);
        }
    }

    public LocalWireNetwork(GlobalWireNetwork globalNet) {
        this.proxyProvider = globalNet.getProxyProvider();
    }

    public CompoundNBT writeToNBT() {
        ListNBT wires = new ListNBT();
        for (ConnectionPoint p : this.connections.keySet()) {
            for (Connection conn : this.connections.get(p)) {
                if (!conn.isPositiveEnd(p)) continue;
                wires.add((Object)conn.toNBT());
            }
        }
        CompoundNBT ret = new CompoundNBT();
        ret.func_218657_a("wires", (INBT)wires);
        HashMultimap connsByBlock = HashMultimap.create();
        for (ConnectionPoint cp : this.connections.keySet()) {
            connsByBlock.put((Object)cp.getPosition(), (Object)cp);
        }
        ListNBT proxies = new ListNBT();
        for (BlockPos p : this.connectors.keySet()) {
            IImmersiveConnectable iic = this.connectors.get(p);
            IImmersiveConnectable proxy = null;
            proxy = iic.isProxy() ? iic : this.proxyProvider.createFor(iic);
            if (proxy == null) continue;
            CompoundNBT complete = new CompoundNBT();
            complete.func_218657_a("proxy", (INBT)this.proxyProvider.toNBT(proxy));
            ListNBT cps = new ListNBT();
            for (ConnectionPoint cp : connsByBlock.get((Object)p)) {
                cps.add((Object)cp.createTag());
            }
            complete.func_218657_a("points", (INBT)cps);
            proxies.add((Object)complete);
        }
        ret.func_218657_a("proxies", (INBT)proxies);
        return ret;
    }

    public Collection<BlockPos> getConnectors() {
        return Collections.unmodifiableCollection(this.connectors.keySet());
    }

    public IImmersiveConnectable getConnector(BlockPos pos) {
        assert (this.connectors.containsKey(pos));
        return this.connectors.get(pos);
    }

    public Collection<Connection> getConnections(BlockPos at) {
        return this.getConnections(new ConnectionPoint(at, 0));
    }

    public Collection<Connection> getConnections(ConnectionPoint at) {
        Collection<Connection> conns = this.connections.get(at);
        if (conns != null) {
            return Collections.unmodifiableCollection(conns);
        }
        return ImmutableSet.of();
    }

    void addConnector(ConnectionPoint cp, IImmersiveConnectable iic, GlobalWireNetwork globalNet) {
        ++this.version;
        Object existing = this.connections.get(cp);
        Preconditions.checkState((existing == null ? 1 : 0) != 0, (String)"Adding connection point %s with connector %s to net %s, but already has %s", (Object)cp, (Object)iic, (Object)this, existing);
        this.connections.put(cp, new ArrayList());
        if (!this.connectors.containsKey(cp.getPosition())) {
            this.loadConnector(cp.getPosition(), iic, true, globalNet);
        } else {
            existing = this.getConnector(cp);
            Preconditions.checkState((existing == iic ? 1 : 0) != 0, (String)"Existing connector in net %s is %s, but expected %s", (Object)this, (Object)existing, (Object)iic);
            this.addRequestedHandlers(iic, globalNet);
        }
    }

    void loadConnector(BlockPos p, IImmersiveConnectable iic, boolean adding, GlobalWireNetwork globalNet) {
        ++this.version;
        IImmersiveConnectable existingIIC = this.connectors.get(p);
        if (adding) {
            Preconditions.checkState((existingIIC == null ? 1 : 0) != 0, (String)"Adding connector %s at %s in net %s, but IIC %s already exists there", (Object)iic, (Object)p, (Object)this, (Object)existingIIC);
        } else if (existingIIC != null && !existingIIC.isProxy()) {
            WireLogger.logger.info("Loading connector {} at {} in net {}, but current IIC is {}, unloading first", (Object)iic, (Object)p, (Object)this, (Object)existingIIC);
            this.unloadConnector(p, existingIIC);
        }
        this.connectors.put(p, iic);
        for (ConnectionPoint cp : iic.getConnectionPoints()) {
            if (!this.connections.containsKey(cp)) continue;
            this.addRequestedHandlers(iic, globalNet);
            for (LocalNetworkHandler h : this.handlers.values()) {
                h.onConnectorLoaded(cp, iic);
            }
        }
    }

    boolean unloadConnector(BlockPos pos, @Nullable IImmersiveConnectable iicToRemove) {
        ++this.version;
        IImmersiveConnectable existingIIC = this.connectors.get(pos);
        if (iicToRemove != existingIIC) {
            WireLogger.logger.info("Tried to remove {} at {} from {}, skipping", (Object)iicToRemove, (Object)pos, (Object)this);
            return false;
        }
        Preconditions.checkState((existingIIC != null ? 1 : 0) != 0, (String)"Unloading connector at %s in net %s, but no connector is stored", (Object)pos, (Object)this);
        Preconditions.checkState((!existingIIC.isProxy() ? 1 : 0) != 0, (String)"Unloading connector at %s in %s, but %s is already a proxy", (Object)pos, (Object)this, (Object)existingIIC);
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectorUnloaded(pos, existingIIC);
        }
        for (ConnectionPoint cp : existingIIC.getConnectionPoints()) {
            if (!this.connections.containsKey(cp)) continue;
            this.removeHandlersFor(existingIIC);
        }
        this.connectors.put(pos, this.proxyProvider.createFor(existingIIC));
        return true;
    }

    LocalWireNetwork merge(LocalWireNetwork other, Supplier<LocalWireNetwork> createNewNet) {
        LocalWireNetwork result = createNewNet.get();
        for (LocalWireNetwork net : new LocalWireNetwork[]{this, other}) {
            result.connectors.putAll(net.connectors);
            result.connections.putAll(net.connections);
        }
        result.handlers.putAll(other.handlers);
        other.handlerUsers.forEach((rl, h) -> result.handlerUsers.put((ResourceLocation)rl, (Multiset<ILocalHandlerProvider>)HashMultiset.create((Iterable)h)));
        for (Map.Entry entry : this.handlers.entrySet()) {
            result.handlers.merge((ResourceLocation)entry.getKey(), (LocalNetworkHandler)entry.getValue(), LocalNetworkHandler::merge);
            result.handlerUsers.merge((ResourceLocation)entry.getKey(), (Multiset<ILocalHandlerProvider>)HashMultiset.create((Iterable)((Iterable)this.handlerUsers.get(entry.getKey()))), (BiFunction<Multiset<ILocalHandlerProvider>, Multiset<ILocalHandlerProvider>, Multiset<ILocalHandlerProvider>>)((BiFunction<Multiset, Multiset, Multiset>)(a, b) -> {
                a.addAll((Collection)b);
                return a;
            }));
        }
        for (Map.Entry entry : result.handlers.entrySet()) {
            ((LocalNetworkHandler)entry.getValue()).setLocalNet(result);
        }
        return result;
    }

    void removeConnection(Connection c) {
        ++this.version;
        for (ConnectionPoint end : new ConnectionPoint[]{c.getEndA(), c.getEndB()}) {
            boolean success = false;
            Collection<Connection> conns = this.connections.get(end);
            if (conns != null) {
                success = conns.remove(c);
            }
            if (success) continue;
            WireLogger.logger.error("Failed to remove {} from {}", (Object)c, (Object)c.getEndB());
        }
        for (ConnectionPoint end : new ConnectionPoint[]{c.getEndA(), c.getEndB()}) {
            IImmersiveConnectable connector = this.connectors.get(end.getPosition());
            if (connector == null) continue;
            connector.removeCable(c, end);
        }
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectionRemoved(c);
        }
        this.removeHandlersFor(c.type);
    }

    void removeConnector(BlockPos p) {
        ++this.version;
        IImmersiveConnectable iic = this.connectors.get(p);
        if (iic == null) {
            for (ConnectionPoint point : this.getConnectionPoints()) {
                if (!point.getPosition().equals((Object)p)) continue;
                WireLogger.logger.info("Cancelling, but connections {} at {} still exist!", this.connections.get(point), (Object)point);
            }
            WireLogger.logger.info("Cancelled");
            return;
        }
        for (ConnectionPoint point : iic.getConnectionPoints()) {
            if (!this.connections.containsKey(point)) continue;
            this.removeHandlersFor(iic);
            for (Connection c : this.getConnections(point)) {
                ConnectionPoint other = c.getOtherEnd(point);
                Collection<Connection> connsOther = this.connections.get(other);
                if (connsOther == null) continue;
                connsOther.remove(c);
            }
            this.connections.remove(point);
        }
        this.connectors.remove(p);
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectorRemoved(p, iic);
        }
    }

    void addConnection(Connection conn, GlobalWireNetwork globalNet) {
        ++this.version;
        IImmersiveConnectable connA = this.connectors.get(conn.getEndA().getPosition());
        Preconditions.checkNotNull((Object)connA, (String)"No connector at %s", (Object)conn.getEndA().getPosition());
        IImmersiveConnectable connB = this.connectors.get(conn.getEndB().getPosition());
        Preconditions.checkNotNull((Object)connB, (String)"No connector at %s", (Object)conn.getEndB().getPosition());
        if (this.connections.get(conn.getEndA()).stream().anyMatch(c -> c.getOtherEnd(conn.getEndA()).equals(conn.getEndB()))) {
            WireLogger.logger.error("Tried to add a duplicate connection from {} ({}) to {} ({})", (Object)conn.getEndA(), (Object)connA, (Object)conn.getEndB(), (Object)connB);
            return;
        }
        this.connections.get(conn.getEndA()).add(conn);
        this.connections.get(conn.getEndB()).add(conn);
        for (LocalNetworkHandler h : this.handlers.values()) {
            h.onConnectionAdded(conn);
        }
        this.addRequestedHandlers(conn.type, globalNet);
    }

    private void removeHandlersFor(ILocalHandlerProvider iic) {
        for (ResourceLocation loc : iic.getRequestedHandlers()) {
            Preconditions.checkState((boolean)this.handlers.containsKey(loc), (String)"Expected to find handler for %s (provided by %s), only found %s", (Object)loc, (Object)iic, this.handlers);
            Multiset<ILocalHandlerProvider> providers = this.getProvidersFor(loc);
            Preconditions.checkState((boolean)providers.contains((Object)iic), (String)"Expected to find handler %s for %s. Found: %s", (Object)iic, (Object)loc, providers);
            providers.remove((Object)iic);
            WireLogger.logger.info("Removing {} from handlers for {}. Remaining: {}", (Object)iic, (Object)loc, providers);
            if (!providers.isEmpty()) continue;
            WireLogger.logger.info("Removing: {}", (Object)loc);
            this.handlers.remove(loc);
            this.handlerUsers.remove(loc);
        }
    }

    private void addRequestedHandlers(ILocalHandlerProvider provider, GlobalWireNetwork global) {
        for (ResourceLocation loc : provider.getRequestedHandlers()) {
            this.getProvidersFor(loc).add((Object)provider);
            if (!this.handlers.containsKey(loc)) {
                this.handlers.put(loc, LocalNetworkHandler.createHandler(loc, this, global));
            }
            WireLogger.logger.info("Adding handler {} for {}", (Object)loc, (Object)provider);
        }
    }

    private Multiset<ILocalHandlerProvider> getProvidersFor(ResourceLocation rl) {
        return this.handlerUsers.computeIfAbsent(rl, rl_ -> HashMultiset.create());
    }

    public Collection<ConnectionPoint> getConnectionPoints() {
        return this.connections.keySet();
    }

    Collection<LocalWireNetwork> split(GlobalWireNetwork globalNet) {
        ++this.version;
        HashSet<ConnectionPoint> toVisit = new HashSet<ConnectionPoint>(this.getConnectionPoints());
        ArrayList<LocalWireNetwork> ret = new ArrayList<LocalWireNetwork>();
        while (!toVisit.isEmpty()) {
            Iterator tmpIt = toVisit.iterator();
            Collection<ConnectionPoint> inComponent = this.getConnectedComponent((ConnectionPoint)tmpIt.next(), toVisit);
            if (toVisit.size() == 0 && ret.size() == 0) break;
            LocalWireNetwork newNet = new LocalWireNetwork(globalNet);
            for (ConnectionPoint p : inComponent) {
                newNet.addConnector(p, this.connectors.get(p.getPosition()), globalNet);
            }
            for (ConnectionPoint p : inComponent) {
                for (Connection c : this.getConnections(p)) {
                    if (!c.isPositiveEnd(p)) continue;
                    newNet.addConnection(c, globalNet);
                }
            }
            ret.add(newNet);
        }
        return ret;
    }

    private Collection<ConnectionPoint> getConnectedComponent(ConnectionPoint start, Set<ConnectionPoint> unvisited) {
        ArrayDeque<ConnectionPoint> open = new ArrayDeque<ConnectionPoint>();
        ArrayList<ConnectionPoint> inComponent = new ArrayList<ConnectionPoint>();
        open.push(start);
        unvisited.remove(start);
        while (!open.isEmpty()) {
            ConnectionPoint curr = (ConnectionPoint)open.pop();
            inComponent.add(curr);
            for (Connection c : this.getConnections(curr)) {
                ConnectionPoint otherEnd = c.getOtherEnd(curr);
                if (!unvisited.contains(otherEnd)) continue;
                unvisited.remove(otherEnd);
                open.push(otherEnd);
            }
        }
        return inComponent;
    }

    public String toString() {
        return "Connectors: " + this.connectors + ", connections: " + this.connections;
    }

    public IImmersiveConnectable getConnector(ConnectionPoint cp) {
        return this.getConnector(cp.getPosition());
    }

    @Override
    public void update(World w) {
        for (LocalNetworkHandler handler : this.handlers.values()) {
            if (!(handler instanceof IWorldTickable)) continue;
            ((IWorldTickable)((Object)handler)).update(w);
        }
        List<Runnable> toRun = this.runNextTick;
        this.runNextTick = new ArrayList<Runnable>();
        for (Runnable r : toRun) {
            r.run();
        }
    }

    @Nullable
    public <T extends LocalNetworkHandler> T getHandler(ResourceLocation name, Class<T> type) {
        LocalNetworkHandler p = this.handlers.get(name);
        if (p == null) {
            return null;
        }
        if (type.isInstance(p)) {
            return (T)p;
        }
        return null;
    }

    public Collection<LocalNetworkHandler> getAllHandlers() {
        return this.handlers.values();
    }

    public void addAsFutureTask(Runnable r) {
        this.runNextTick.add(r);
    }

    void removeCP(ConnectionPoint cp) {
        ++this.version;
        for (Connection c : this.getConnections(cp).toArray(new Connection[0])) {
            this.removeConnection(c);
        }
        this.connections.remove(cp);
        boolean hasMoreAtSameBlock = true;
        for (ConnectionPoint cp2 : this.connections.keySet()) {
            if (!cp.getPosition().equals((Object)cp2.getPosition())) continue;
            hasMoreAtSameBlock = false;
            break;
        }
        if (hasMoreAtSameBlock) {
            this.removeConnector(cp.getPosition());
        }
    }

    public void setInvalid() {
        ++this.version;
        this.isValid = false;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public boolean isValid(ConnectionPoint cp) {
        return this.isValid && this.connections.containsKey(cp);
    }

    public int getVersion() {
        return this.version;
    }
}

