/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import java.util.List;
import java.util.Objects;
import net.minecraft.block.AbstractRailBlock;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.extensions.IForgeEntityMinecart;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class CapabilityUtils {
    public static <T> LazyOptional<T> findCapabilityAtPos(Capability<T> capability, World world, BlockPos pos, Direction side, boolean allowCart) {
        LazyOptional cap;
        List list;
        LazyOptional cap2;
        TileEntity neighbourTile = world.func_175625_s(pos);
        if (neighbourTile != null && (cap2 = neighbourTile.getCapability(capability, side)).isPresent()) {
            return cap2;
        }
        if (allowCart && AbstractRailBlock.func_208488_a((World)world, (BlockPos)pos) && !(list = world.func_175674_a(null, new AxisAlignedBB(pos), entity -> entity instanceof IForgeEntityMinecart)).isEmpty() && (cap = ((Entity)list.get(world.field_73012_v.nextInt(list.size()))).getCapability(capability)).isPresent()) {
            return cap;
        }
        return LazyOptional.empty();
    }

    public static LazyOptional<IItemHandler> findItemHandlerAtPos(World world, BlockPos pos, Direction side, boolean allowCart) {
        return CapabilityUtils.findCapabilityAtPos(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, world, pos, side, allowCart);
    }

    public static LazyOptional<IFluidHandler> findFluidHandlerAtPos(World world, BlockPos pos, Direction side, boolean allowCart) {
        return CapabilityUtils.findCapabilityAtPos(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, world, pos, side, allowCart);
    }

    public static boolean canInsertStackIntoInventory(TileEntity inventory, ItemStack stack, Direction side) {
        if (!stack.func_190926_b() && inventory != null) {
            return inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> {
                ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)true);
                return temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E();
            }).orElse(false);
        }
        return false;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, Direction side) {
        if (!stack.func_190926_b() && inventory != null) {
            return inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> {
                ItemStack temp = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)true);
                if (temp.func_190926_b() || temp.func_190916_E() < stack.func_190916_E()) {
                    return ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)false);
                }
                return stack;
            }).orElse(stack);
        }
        return stack;
    }

    public static ItemStack insertStackIntoInventory(TileEntity inventory, ItemStack stack, Direction side, boolean simulate) {
        if (inventory != null && !stack.func_190926_b()) {
            return inventory.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side).map(handler -> ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack.func_77946_l(), (boolean)simulate)).orElse(stack);
        }
        return stack;
    }

    public static <T> LazyOptional<T> constantOptional(T val) {
        LazyOptional result = LazyOptional.of(() -> Objects.requireNonNull(val));
        result.resolve();
        return result;
    }
}

