/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.client.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.fluid.FluidState;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.chunk.IChunkLightProvider;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.lighting.WorldLightManager;
import org.apache.commons.lang3.ArrayUtils;
import team.chisel.Chisel;
import team.chisel.api.IChiselItem;
import team.chisel.client.gui.GuiChisel;
import team.chisel.client.gui.PacketChiselButton;
import team.chisel.client.gui.PacketHitechSettings;
import team.chisel.client.gui.PreviewType;
import team.chisel.client.util.ChiselLangKeys;
import team.chisel.common.inventory.ContainerChiselHitech;
import team.chisel.common.util.NBTUtil;

@ParametersAreNonnullByDefault
public class GuiHitechChisel
extends GuiChisel<ContainerChiselHitech> {
    private static final Rectangle2d panel = new Rectangle2d(8, 14, 74, 74);
    private static final ResourceLocation TEXTURE = new ResourceLocation("chisel", "textures/chiselguihitech.png");
    private final ContainerChiselHitech containerHitech;
    private FakeBlockAccess fakeworld = new FakeBlockAccess(this);
    private boolean panelClicked;
    private int clickButton;
    private long lastDragTime;
    private int clickX;
    private int clickY;
    private double initRotX;
    private double initRotY;
    private double initZoom;
    private double prevRotX;
    private double prevRotY;
    private double momentumX;
    private double momentumY;
    private float momentumDampening = 0.98f;
    private double rotX = 165.0;
    private double rotY;
    private double zoom = 1.0;
    private int scrollAcc;
    @Nullable
    private PreviewModeButton buttonPreview;
    @Nullable
    private Button buttonChisel;
    @Nullable
    private RotateButton buttonRotate;
    @Nullable
    private BlockState erroredState;
    private boolean doMomentum = false;

    public GuiHitechChisel(ContainerChiselHitech container, PlayerInventory iinventory, ITextComponent displayName) {
        super(container, iinventory, displayName);
        this.containerHitech = container;
        this.field_146999_f = 256;
        this.field_147000_g = 220;
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int x = this.field_147003_i + panel.func_199318_a() - 1;
        int y = this.field_147009_r + panel.func_199319_b() + panel.func_199317_d() + 3;
        int w = 76;
        int h = 20;
        boolean firstInit = this.buttonPreview == null;
        this.buttonPreview = new PreviewModeButton(x, y, w, h);
        this.func_230480_a_((Widget)this.buttonPreview);
        this.buttonChisel = new Button(x, y += h + 2, w, h, (ITextComponent)ChiselLangKeys.BUTTON_CHISEL.getComponent(), b -> {
            Slot target = this.containerHitech.getTarget();
            Slot selected = this.containerHitech.getSelection();
            if (target != null && target.func_75216_d() && selected != null && selected.func_75216_d()) {
                if (ItemStack.func_179545_c((ItemStack)target.func_75211_c(), (ItemStack)selected.func_75211_c())) {
                    return;
                }
                ItemStack converted = target.func_75211_c().func_77946_l();
                converted.func_190920_e(selected.func_75211_c().func_190916_E());
                int[] slots = new int[]{selected.getSlotIndex()};
                if (GuiHitechChisel.func_231173_s_()) {
                    slots = ArrayUtils.addAll((int[])slots, (int[])this.containerHitech.getSelectionDuplicates().stream().mapToInt(Slot::getSlotIndex).toArray());
                }
                Chisel.network.sendToServer((Object)new PacketChiselButton(slots));
                PacketChiselButton.chiselAll(this.player, slots);
                if (!GuiHitechChisel.func_231173_s_()) {
                    List<Slot> dupes = this.containerHitech.getSelectionDuplicates();
                    Slot next = selected;
                    for (Slot s : dupes) {
                        if (s.field_75222_d <= selected.field_75222_d) continue;
                        next = s;
                        break;
                    }
                    if (next == selected && dupes.size() > 0) {
                        next = dupes.get(0);
                    }
                    this.containerHitech.setSelection(next);
                } else {
                    this.containerHitech.setSelection(selected);
                }
            }
        });
        this.func_230480_a_((Widget)this.buttonChisel);
        this.buttonRotate = new RotateButton(this.field_147003_i + panel.func_199318_a() + panel.func_199316_c() - 16, this.field_147009_r + panel.func_199319_b() + panel.func_199317_d() - 16);
        this.func_230480_a_((Widget)this.buttonRotate);
        ItemStack chisel = this.containerHitech.getChisel();
        if (firstInit) {
            this.buttonPreview.setType(NBTUtil.getHitechType(chisel));
            this.buttonRotate.rotate = NBTUtil.getHitechRotate(chisel);
        }
        this.func_231023_e_();
    }

    @Override
    protected Rectangle2d getModeButtonArea() {
        int down = 133;
        int padding = 7;
        return new Rectangle2d(this.field_147003_i + padding, this.field_147009_r + down + padding, 76, this.field_147000_g - down - padding * 2);
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        boolean bl = this.buttonChisel.field_230693_o_ = this.containerHitech.getSelection() != null && this.containerHitech.getSelection().func_75216_d() && this.containerHitech.getTarget() != null && this.containerHitech.getTarget().func_75216_d();
        if (!this.panelClicked) {
            this.initRotX = this.rotX;
            this.initRotY = this.rotY;
            this.initZoom = this.zoom;
        }
        if (GuiHitechChisel.func_231173_s_()) {
            this.buttonChisel.func_238482_a_((ITextComponent)ChiselLangKeys.BUTTON_CHISEL_ALL.getComponent().func_240699_a_(TextFormatting.YELLOW));
        } else {
            this.buttonChisel.func_238482_a_((ITextComponent)ChiselLangKeys.BUTTON_CHISEL.getComponent());
        }
    }

    private void updateChiselData() {
        ItemStack stack = this.containerHitech.getChisel();
        if (!(stack.func_77973_b() instanceof IChiselItem)) {
            return;
        }
        NBTUtil.setHitechType(stack, this.buttonPreview.getType().ordinal());
        NBTUtil.setHitechRotate(stack, this.buttonRotate.rotate());
        Chisel.network.sendToServer((Object)new PacketHitechSettings(this.containerHitech.getChisel(), this.containerHitech.getChiselSlot()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void func_230450_a_(MatrixStack matrixStack, float f, int mx, int my) {
        ItemStack stack;
        Slot sel;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TEXTURE);
        this.func_238474_b_(matrixStack, this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.containerHitech.getSelection() != null && (sel = this.containerHitech.getSelection()).func_75216_d()) {
            this.drawSlotHighlight(matrixStack, sel, 0);
            for (Slot s : this.containerHitech.getSelectionDuplicates()) {
                this.drawSlotHighlight(matrixStack, s, GuiHitechChisel.func_231173_s_() ? 0 : 18);
            }
        }
        if (this.containerHitech.getTarget() != null && !this.containerHitech.getTarget().func_75211_c().func_190926_b()) {
            this.drawSlotHighlight(matrixStack, this.containerHitech.getTarget(), 36);
        }
        if (this.buttonRotate.rotate() && this.momentumX == 0.0 && this.momentumY == 0.0 && !this.panelClicked && System.currentTimeMillis() - this.lastDragTime > 2000L) {
            this.rotY = this.initRotY + (double)(f * 2.0f);
        }
        if (this.panelClicked && this.clickButton == 0) {
            this.momentumX = this.rotX - this.prevRotX;
            this.momentumY = this.rotY - this.prevRotY;
            this.prevRotX = this.rotX;
            this.prevRotY = this.rotY;
        }
        BlockRendererDispatcher brd = Minecraft.func_71410_x().func_175602_ab();
        if (this.containerHitech.getTarget() != null && !(stack = this.containerHitech.getTarget().func_75211_c()).func_190926_b()) {
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)(panel.func_199318_a() + panel.func_199316_c() / 2), (float)(panel.func_199319_b() + panel.func_199317_d() / 2), (float)100.0f);
            RenderSystem.matrixMode((int)5889);
            RenderSystem.pushMatrix();
            RenderSystem.loadIdentity();
            int scale = (int)this.getMinecraft().func_228018_at_().func_198100_s();
            RenderSystem.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)60.0, (float)((float)panel.func_199316_c() / (float)panel.func_199317_d()), (float)0.01f, (float)4000.0f));
            RenderSystem.matrixMode((int)5888);
            RenderSystem.translated((double)(-panel.func_199318_a() - panel.func_199316_c() / 2), (double)(-panel.func_199319_b() - panel.func_199317_d() / 2), (double)0.0);
            RenderSystem.viewport((int)((this.field_147003_i + panel.func_199318_a()) * scale), (int)(this.getMinecraft().func_228018_at_().func_198083_n() - (this.field_147009_r + panel.func_199319_b() + panel.func_199317_d()) * scale), (int)(panel.func_199316_c() * scale), (int)(panel.func_199317_d() * scale));
            RenderSystem.clear((int)256, (boolean)true);
            double sc = 300.0 + (double)(8.0f * this.buttonPreview.getType().getScale()) * (Math.sqrt(this.zoom + 99.0) - 9.0);
            RenderSystem.scaled((double)(-sc), (double)(-sc), (double)sc);
            RenderSystem.rotatef((float)((float)(-this.rotX)), (float)1.0f, (float)0.0f, (float)0.0f);
            RenderSystem.rotatef((float)((float)this.rotY), (float)0.0f, (float)1.0f, (float)0.0f);
            RenderSystem.translated((double)-1.5, (double)-2.5, (double)-0.5);
            RenderSystem.enableDepthTest();
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            BlockState state = block.func_176223_P();
            if (state != null && state != this.erroredState) {
                this.erroredState = null;
                this.fakeworld.setState(state);
                this.getMinecraft().func_110434_K().func_110577_a(AtlasTexture.field_110575_b);
                Tessellator.func_178181_a().func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
                try {
                    MatrixStack ms = new MatrixStack();
                    for (BlockPos pos : this.buttonPreview.getType().getPositions()) {
                        ms.func_227860_a_();
                        ms.func_227861_a_((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                        brd.func_228793_a_(state, pos, (IBlockDisplayReader)this.fakeworld, ms, (IVertexBuilder)Tessellator.func_178181_a().func_178180_c(), true, new Random());
                        ms.func_227865_b_();
                    }
                }
                catch (Exception e) {
                    this.erroredState = state;
                    Chisel.logger.error("Exception rendering block {}", (Object)state, (Object)e);
                }
                finally {
                    if (this.erroredState == null) {
                        Tessellator.func_178181_a().func_78381_a();
                    } else {
                        Tessellator.func_178181_a().func_178180_c().func_178977_d();
                    }
                }
            }
            RenderSystem.popMatrix();
            RenderSystem.matrixMode((int)5889);
            RenderSystem.popMatrix();
            RenderSystem.matrixMode((int)5888);
            RenderSystem.viewport((int)0, (int)0, (int)this.getMinecraft().func_228018_at_().func_198105_m(), (int)this.getMinecraft().func_228018_at_().func_198083_n());
        }
    }

    private void drawSlotHighlight(MatrixStack matrixStack, Slot slot, int u) {
        this.func_238474_b_(matrixStack, this.field_147003_i + slot.field_75223_e - 1, this.field_147009_r + slot.field_75221_f - 1, u, 220, 18, 18);
    }

    @Override
    protected void func_230451_b_(MatrixStack matrixStack, int j, int i) {
        if (this.doMomentum) {
            this.rotX += this.momentumX;
            this.rotX = MathHelper.func_151237_a((double)this.rotX, (double)90.0, (double)270.0);
            this.rotY += this.momentumY;
            this.momentumX *= (double)this.momentumDampening;
            this.momentumY *= (double)this.momentumDampening;
            if (Math.abs(this.momentumX) < 0.2) {
                this.momentumX = Math.abs(this.momentumX) < 0.05 ? 0.0 : (this.momentumX *= (double)(this.momentumDampening * this.momentumDampening));
            }
            if (Math.abs(this.momentumY) < 0.2) {
                this.momentumY = Math.abs(this.momentumY) < 0.05 ? 0.0 : (this.momentumY *= (double)(this.momentumDampening * this.momentumDampening));
            }
        }
        TranslationTextComponent s = ChiselLangKeys.PREVIEW.getComponent();
        this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)s, (float)(panel.func_199318_a() + panel.func_199316_c() / 2 - this.field_230712_o_.func_238414_a_((ITextProperties)s) / 2), (float)(panel.func_199319_b() - 9), 0x404040);
        RenderSystem.disableAlphaTest();
        this.drawButtonTooltips(matrixStack, j, i);
    }

    @Override
    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        boolean ret = super.func_231044_a_(mouseX, mouseY, mouseButton);
        if (!ret && !this.buttonRotate.func_231047_b_(mouseX, mouseY) && panel.func_199315_b((int)(mouseX - (double)this.field_147003_i), (int)(mouseY - (double)this.field_147009_r))) {
            if (mouseButton == 0) {
                this.doMomentum = false;
            }
            this.clickButton = mouseButton;
            this.panelClicked = true;
            this.clickX = (int)mouseX;
            this.clickY = (int)mouseY;
            return true;
        }
        return ret;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int p_mouseDragged_5_, double p_mouseDragged_6_, double p_mouseDragged_8_) {
        if (this.panelClicked) {
            if (this.clickButton == 0) {
                this.rotX = MathHelper.func_151237_a((double)(this.initRotX + mouseY - (double)this.clickY), (double)90.0, (double)270.0);
                this.rotY = this.initRotY + mouseX - (double)this.clickX;
            } else if (this.clickButton == 1) {
                this.zoom = Math.max(1.0, this.initZoom + ((double)this.clickY - mouseY));
            }
        }
        return super.func_231045_a_(mouseX, mouseY, p_mouseDragged_5_, p_mouseDragged_6_, p_mouseDragged_8_);
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int state) {
        if (this.panelClicked) {
            this.lastDragTime = System.currentTimeMillis();
        }
        this.doMomentum = true;
        this.panelClicked = false;
        this.initRotX = this.rotX;
        this.initRotY = this.rotY;
        this.initZoom = this.zoom;
        return super.func_231048_c_(mouseX, mouseY, state);
    }

    private static class FakeBlockAccess
    implements IBlockDisplayReader {
        private final GuiHitechChisel gui;
        private BlockState state = Blocks.field_150350_a.func_176223_P();
        private final WorldLightManager light = new WorldLightManager(new IChunkLightProvider(){

            public IBlockReader func_212864_k_() {
                return this;
            }

            @Nullable
            public IBlockReader func_217202_b(int p_217202_1_, int p_217202_2_) {
                return this;
            }
        }, true, true);

        @Nullable
        public TileEntity func_175625_s(BlockPos pos) {
            return null;
        }

        public BlockState func_180495_p(BlockPos pos) {
            return this.gui.buttonPreview.getType().getPositions().contains(pos) ? this.state : Blocks.field_150350_a.func_176223_P();
        }

        public FluidState func_204610_c(BlockPos pos) {
            return Fluids.field_204541_a.func_207188_f();
        }

        public WorldLightManager func_225524_e_() {
            return this.light;
        }

        public int func_225525_a_(BlockPos blockPosIn, ColorResolver colorResolverIn) {
            return -1;
        }

        public int func_217298_h(BlockPos p_217298_1_) {
            return 15;
        }

        public float func_230487_a_(Direction p_230487_1_, boolean p_230487_2_) {
            return Minecraft.func_71410_x().field_71441_e.func_230487_a_(p_230487_1_, p_230487_2_);
        }

        public FakeBlockAccess(GuiHitechChisel gui) {
            this.gui = gui;
        }

        public void setState(BlockState state) {
            this.state = state;
        }
    }

    private class RotateButton
    extends Button {
        private boolean rotate;

        public RotateButton(int x, int y) {
            super(x, y, 16, 16, (ITextComponent)new StringTextComponent(""), b -> {});
            this.rotate = true;
        }

        public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            this.field_230692_n_ = mouseX >= this.field_230690_l_ && mouseY >= this.field_230691_m_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY < this.field_230691_m_ + this.field_230689_k_;
            GuiHitechChisel.this.getMinecraft().func_110434_K().func_110577_a(TEXTURE);
            float a = this.func_231047_b_(mouseX, mouseY) ? 1.0f : 0.2f;
            int u = this.rotate ? 0 : 16;
            int v = 238;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)a);
            RenderSystem.enableBlend();
            RenderSystem.enableDepthTest();
            this.func_230926_e_(1000);
            this.func_238474_b_(matrixStack, this.field_230690_l_, this.field_230691_m_, u, v, 16, 16);
            this.func_230926_e_(0);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int i) {
            if (super.func_231044_a_(mouseX, mouseY, i)) {
                this.rotate = !this.rotate;
                GuiHitechChisel.this.updateChiselData();
                return true;
            }
            return false;
        }

        public boolean rotate() {
            return this.rotate;
        }
    }

    private class PreviewModeButton
    extends Button {
        private PreviewType type;

        public PreviewModeButton(int x, int y, int widthIn, int heightIn) {
            super(x, y, widthIn, heightIn, (ITextComponent)new StringTextComponent(""), b -> {});
            this.setType(PreviewType.values()[0]);
        }

        public boolean func_231044_a_(double mouseX, double mouseY, int i) {
            if (super.func_231044_a_(mouseX, mouseY, i)) {
                this.setType(PreviewType.values()[(this.type.ordinal() + 1) % PreviewType.values().length]);
                GuiHitechChisel.this.updateChiselData();
                return true;
            }
            return false;
        }

        private final void setType(PreviewType type) {
            this.type = type;
            this.func_238482_a_((ITextComponent)new StringTextComponent("< ").func_230529_a_((ITextComponent)type.getLocalizedName()).func_240702_b_(" >"));
            GuiHitechChisel.this.fakeworld = new FakeBlockAccess(GuiHitechChisel.this);
        }

        public PreviewType getType() {
            return this.type;
        }
    }
}

