/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.api.block;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import team.chisel.api.block.BlockCreator;
import team.chisel.api.block.BlockProvider;
import team.chisel.api.block.ChiselBlockBuilder;
import team.chisel.api.block.VariationData;
import team.chisel.common.block.BlockCarvable;
import team.chisel.common.block.ItemChiselBlock;
import team.chisel.repack.registrate.Registrate;

@ParametersAreNonnullByDefault
public class ChiselBlockFactory {
    private final Registrate registrate;
    private final Map<ResourceLocation, ITag.INamedTag<Block>> blockTags = new HashMap<ResourceLocation, ITag.INamedTag<Block>>();
    private final Map<ResourceLocation, ITag.INamedTag<Item>> itemTags = new HashMap<ResourceLocation, ITag.INamedTag<Item>>();

    public static ChiselBlockFactory newFactory(Registrate registrate) {
        return new ChiselBlockFactory(registrate);
    }

    public ChiselBlockBuilder<BlockCarvable> newType(Material material, String blockName) {
        return this.newType(material, blockName, BlockCarvable::new);
    }

    public <T extends Block> ChiselBlockBuilder<T> newType(Material material, String blockName, final BlockCreator<T> creator) {
        return this.newType(material, blockName, new BlockProvider<T>(){

            @Override
            public T createBlock(AbstractBlock.Properties properties, VariationData data) {
                return creator.createBlock(properties, data);
            }

            @Override
            public BlockItem createBlockItem(T block, Item.Properties properties) {
                return new ItemChiselBlock((Block)block, properties);
            }
        });
    }

    public <T extends Block> ChiselBlockBuilder<T> newType(Material material, String blockName, BlockProvider<T> provider) {
        return this.newType(material, blockName, blockName, provider);
    }

    public <T extends Block> ChiselBlockBuilder<T> newType(Material material, String blockName, @Nullable String group, BlockProvider<T> provider) {
        return new ChiselBlockBuilder<T>(this, this.registrate, material, blockName, group == null ? null : this.getBlockTag(new ResourceLocation("chisel", group)), provider);
    }

    ITag.INamedTag<Block> getBlockTag(ResourceLocation id) {
        return this.blockTags.computeIfAbsent(id, rl -> BlockTags.func_199894_a((String)rl.toString()));
    }

    ITag.INamedTag<Item> getItemTag(ResourceLocation id) {
        return this.itemTags.computeIfAbsent(id, rl -> ItemTags.func_199901_a((String)rl.toString()));
    }

    public Registrate getRegistrate() {
        return this.registrate;
    }

    private ChiselBlockFactory(Registrate registrate) {
        this.registrate = registrate;
    }
}

