/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client.render.gun.model;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mrcrayfish.guns.client.SpecialModels;
import com.mrcrayfish.guns.client.render.gun.IOverrideModel;
import com.mrcrayfish.guns.client.util.RenderUtil;
import com.mrcrayfish.guns.common.Gun;
import com.mrcrayfish.guns.init.ModSyncedDataKeys;
import com.mrcrayfish.obfuscate.common.data.SyncedPlayerData;
import java.util.WeakHashMap;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class MiniGunModel
implements IOverrideModel {
    private WeakHashMap<LivingEntity, Rotations> rotationMap = new WeakHashMap();

    @Override
    public void tick(PlayerEntity entity) {
        this.rotationMap.putIfAbsent((LivingEntity)entity, new Rotations());
        Rotations rotations = this.rotationMap.get(entity);
        rotations.prevRotation = rotations.rotation;
        boolean shooting = (Boolean)SyncedPlayerData.instance().get(entity, ModSyncedDataKeys.SHOOTING);
        ItemStack heldItem = entity.func_184614_ca();
        if (!Gun.hasAmmo(heldItem) && !entity.func_184812_l_()) {
            shooting = false;
        }
        if (shooting) {
            Rotations rotations2 = rotations;
            rotations2.rotation = rotations2.rotation + 20;
        } else {
            Rotations rotations3 = rotations;
            rotations3.rotation = rotations3.rotation + 1;
        }
    }

    @Override
    public void render(float partialTicks, ItemCameraTransforms.TransformType transformType, ItemStack stack, ItemStack parent, LivingEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, int overlay) {
        Rotations rotations = this.rotationMap.computeIfAbsent(entity, uuid -> new Rotations());
        RenderUtil.renderModel(SpecialModels.MINI_GUN_BASE.getModel(), stack, matrixStack, renderTypeBuffer, light, overlay);
        RenderUtil.renderModel(SpecialModels.MINI_GUN_BARRELS.getModel(), ItemCameraTransforms.TransformType.NONE, () -> RenderUtil.rotateZ(matrixStack, 0.5f, 0.125f, (float)rotations.prevRotation + (float)(rotations.rotation - rotations.prevRotation) * partialTicks), stack, parent, matrixStack, renderTypeBuffer, light, overlay);
    }

    @SubscribeEvent
    public void onClientDisconnect(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        this.rotationMap.clear();
    }

    private class Rotations {
        private int rotation;
        private int prevRotation;

        private Rotations() {
        }
    }
}

