/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.guns.client;

import java.lang.ref.WeakReference;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class BulletTrail {
    private int entityId;
    private Vector3d position;
    private Vector3d motion;
    private float yaw;
    private float pitch;
    private boolean dead;
    private ItemStack item;
    private int trailColor;
    private double trailLengthMultiplier;
    private int age;
    private int maxAge;
    private double gravity;
    private int shooterId;
    private WeakReference<Entity> shooter;

    public BulletTrail(int entityId, Vector3d position, Vector3d motion, ItemStack item, int trailColor, double trailMultiplier, int maxAge, double gravity, int shooterId) {
        this.entityId = entityId;
        this.position = position;
        this.motion = motion;
        this.item = item;
        this.trailColor = trailColor;
        this.trailLengthMultiplier = trailMultiplier;
        this.maxAge = maxAge;
        this.gravity = gravity;
        this.shooterId = shooterId;
        this.updateYawPitch();
    }

    private void updateYawPitch() {
        float horizontalLength = MathHelper.func_76133_a((double)(this.motion.field_72450_a * this.motion.field_72450_a + this.motion.field_72449_c * this.motion.field_72449_c));
        this.yaw = (float)Math.toDegrees(MathHelper.func_181159_b((double)this.motion.field_72450_a, (double)this.motion.field_72449_c));
        this.pitch = (float)Math.toDegrees(MathHelper.func_181159_b((double)this.motion.field_72448_b, (double)horizontalLength));
    }

    public void tick() {
        Entity entity;
        double distance;
        ++this.age;
        this.position = this.position.func_178787_e(this.motion);
        if (this.gravity != 0.0) {
            this.motion = this.motion.func_72441_c(0.0, this.gravity, 0.0);
            this.updateYawPitch();
        }
        double d = distance = (entity = Minecraft.func_71410_x().func_175606_aa()) != null ? Math.sqrt(entity.func_195048_a(this.position)) : Double.MAX_VALUE;
        if (this.age >= this.maxAge || distance > 256.0) {
            this.dead = true;
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public Vector3d getMotion() {
        return this.motion;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean isDead() {
        return this.dead;
    }

    public int getAge() {
        return this.age;
    }

    public ItemStack getItem() {
        return this.item;
    }

    public int getTrailColor() {
        return this.trailColor;
    }

    public double getTrailLengthMultiplier() {
        return this.trailLengthMultiplier;
    }

    public int getShooterId() {
        return this.shooterId;
    }

    @Nullable
    public Entity getShooter() {
        Entity entity;
        ClientWorld world;
        if (this.shooter == null && (world = Minecraft.func_71410_x().field_71441_e) != null && (entity = world.func_73045_a(this.shooterId)) != null) {
            this.shooter = new WeakReference<Entity>(entity);
        }
        if (this.shooter != null) {
            Entity entity2 = (Entity)this.shooter.get();
            if (entity2 != null && !entity2.func_70089_S()) {
                return null;
            }
            return entity2;
        }
        return null;
    }

    public boolean isTrailVisible() {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        return entity != null && entity.func_145782_y() != this.shooterId;
    }

    public int hashCode() {
        return this.entityId;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BulletTrail) {
            return ((BulletTrail)obj).entityId == this.entityId;
        }
        return false;
    }
}

