/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.morefurniture.datagen;

import com.mrcrayfish.furniture.core.ModBlocks;
import com.mrcrayfish.morefurniture.Generator;
import java.util.function.Consumer;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.ConditionalRecipe;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.fml.RegistryObject;

public class RecipeGen
extends RecipeProvider {
    public RecipeGen(DataGenerator generator) {
        super(generator);
    }

    private static Block getResultBlock(Generator.Variant variant, Generator.FurnitureType type, boolean stripped) {
        try {
            String fieldFormat = stripped ? "%s_%s_STRIPPED_%s" : "%s_%s_%s";
            String fieldName = String.format(fieldFormat, variant.getLog().getRegistryName().func_110624_b().toUpperCase(), type.getId().toUpperCase(), variant.getId().toUpperCase());
            RegistryObject block = (RegistryObject)com.mrcrayfish.morefurniture.init.ModBlocks.class.getField(fieldName).get(null);
            return (Block)block.get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Block getUpgradedFence(Generator.Variant variant, boolean stripped) {
        try {
            String fieldFormat = stripped ? "%s_UPGRADED_FENCE_STRIPPED_%s" : "%s_UPGRADED_FENCE_%s";
            String fieldName = String.format(fieldFormat, variant.getLog().getRegistryName().func_110624_b().toUpperCase(), variant.getId().toUpperCase());
            RegistryObject block = (RegistryObject)com.mrcrayfish.morefurniture.init.ModBlocks.class.getField(fieldName).get(null);
            return (Block)block.get();
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        Generator generator = new Generator();
        generator.getRegisteredVariants().forEach(variant -> {
            RecipeGen.table(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.TABLE, false), (IItemProvider)variant.getLog(), (IItemProvider)variant.getPlanks());
            RecipeGen.chair(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.CHAIR, false), (IItemProvider)variant.getLog(), (IItemProvider)variant.getPlanks());
            RecipeGen.coffeeTable(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.COFFEE_TABLE, false), (IItemProvider)variant.getLog(), (IItemProvider)variant.getPlanks());
            RecipeGen.cabinet(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.CABINET, false), (IItemProvider)variant.getLog(), (IItemProvider)variant.getPlanks());
            RecipeGen.bedsideCabinet(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.BEDSIDE_CABINET, false), (IItemProvider)variant.getLog(), (IItemProvider)variant.getPlanks());
            RecipeGen.desk(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.DESK, false), (IItemProvider)variant.getLog(), (IItemProvider)variant.getPlanks());
            RecipeGen.deskCabinet(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.DESK_CABINET, false), (IItemProvider)variant.getLog(), (IItemProvider)variant.getPlanks());
            RecipeGen.blinds(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.BLINDS, false), (IItemProvider)variant.getLog());
            RecipeGen.upgradedFence(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.UPGRADED_FENCE, false), (IItemProvider)variant.getLog());
            RecipeGen.upgradedGate(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.UPGRADED_GATE, false), (IItemProvider)variant.getLog());
            RecipeGen.crate(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.CRATE, false), (IItemProvider)variant.getLog(), (IItemProvider)variant.getPlanks());
            RecipeGen.parkBench(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.PARK_BENCH, false), (IItemProvider)variant.getLog(), (IItemProvider)variant.getPlanks());
            RecipeGen.kitchenCounter(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.KITCHEN_COUNTER, false), (IItemProvider)variant.getLog(), (IItemProvider)variant.getPlanks());
            RecipeGen.kitchenDrawer(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.KITCHEN_DRAWER, false), (IItemProvider)variant.getLog(), (IItemProvider)variant.getPlanks());
            RecipeGen.kitchenSink(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.KITCHEN_SINK_LIGHT, false), (IItemProvider)Blocks.field_196828_iC, (IItemProvider)variant.getPlanks());
            RecipeGen.kitchenSink(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.KITCHEN_SINK_DARK, false), (IItemProvider)Blocks.field_196842_iJ, (IItemProvider)variant.getPlanks());
            RecipeGen.mailBox(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.MAIL_BOX, false), (IItemProvider)RecipeGen.getUpgradedFence(variant, false), variant.getLog().getRegistryName().func_110624_b());
            if (variant.getStrippedLog() != null) {
                RecipeGen.table(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.TABLE, true), (IItemProvider)variant.getStrippedLog(), (IItemProvider)variant.getLog());
                RecipeGen.chair(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.CHAIR, true), (IItemProvider)variant.getStrippedLog(), (IItemProvider)variant.getLog());
                RecipeGen.coffeeTable(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.COFFEE_TABLE, true), (IItemProvider)variant.getStrippedLog(), (IItemProvider)variant.getLog());
                RecipeGen.cabinet(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.CABINET, true), (IItemProvider)variant.getLog(), (IItemProvider)variant.getStrippedLog());
                RecipeGen.bedsideCabinet(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.BEDSIDE_CABINET, true), (IItemProvider)variant.getStrippedLog(), (IItemProvider)variant.getLog());
                RecipeGen.desk(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.DESK, true), (IItemProvider)variant.getStrippedLog(), (IItemProvider)variant.getLog());
                RecipeGen.deskCabinet(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.DESK_CABINET, true), (IItemProvider)variant.getStrippedLog(), (IItemProvider)variant.getLog());
                RecipeGen.blinds(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.BLINDS, true), (IItemProvider)variant.getStrippedLog());
                RecipeGen.upgradedFence(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.UPGRADED_FENCE, true), (IItemProvider)variant.getStrippedLog());
                RecipeGen.upgradedGate(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.UPGRADED_GATE, true), (IItemProvider)variant.getStrippedLog());
                RecipeGen.crate(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.CRATE, true), (IItemProvider)variant.getStrippedLog(), (IItemProvider)variant.getLog());
                RecipeGen.parkBench(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.PARK_BENCH, true), (IItemProvider)variant.getLog(), (IItemProvider)variant.getStrippedLog());
                RecipeGen.kitchenCounter(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.KITCHEN_COUNTER, true), (IItemProvider)variant.getLog(), (IItemProvider)variant.getStrippedLog());
                RecipeGen.kitchenDrawer(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.KITCHEN_DRAWER, true), (IItemProvider)variant.getLog(), (IItemProvider)variant.getStrippedLog());
                RecipeGen.kitchenSink(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.KITCHEN_SINK_LIGHT, true), (IItemProvider)Blocks.field_196828_iC, (IItemProvider)variant.getStrippedLog());
                RecipeGen.kitchenSink(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.KITCHEN_SINK_DARK, true), (IItemProvider)Blocks.field_196842_iJ, (IItemProvider)variant.getStrippedLog());
                RecipeGen.mailBox(consumer, (IItemProvider)RecipeGen.getResultBlock(variant, Generator.MAIL_BOX, true), (IItemProvider)RecipeGen.getUpgradedFence(variant, true), variant.getLog().getRegistryName().func_110624_b());
            }
        });
    }

    private static void table(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider table, IItemProvider log, IItemProvider planks) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)table, (int)4).func_200472_a("LLL").func_200472_a(" P ").func_200472_a(" P ").func_200462_a(Character.valueOf('L'), log).func_200462_a(Character.valueOf('P'), planks).func_200473_b("table").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_planks", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)planks))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, table.func_199767_j().getRegistryName());
    }

    private static void chair(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider chair, IItemProvider log, IItemProvider planks) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)chair, (int)4).func_200472_a("L  ").func_200472_a("LLL").func_200472_a("P P").func_200462_a(Character.valueOf('L'), log).func_200462_a(Character.valueOf('P'), planks).func_200473_b("chair").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_planks", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)planks))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, chair.func_199767_j().getRegistryName());
    }

    private static void coffeeTable(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider table, IItemProvider log, IItemProvider planks) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)table, (int)4).func_200472_a("LLL").func_200472_a("P P").func_200462_a(Character.valueOf('L'), log).func_200462_a(Character.valueOf('P'), planks).func_200473_b("coffee_table").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_planks", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)planks))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, table.func_199767_j().getRegistryName());
    }

    private static void cabinet(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider cabinet, IItemProvider log, IItemProvider planks) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)cabinet, (int)2).func_200472_a("PPL").func_200472_a("P L").func_200472_a("PPL").func_200462_a(Character.valueOf('L'), log).func_200462_a(Character.valueOf('P'), planks).func_200473_b("cabinet").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_planks", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)planks))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, cabinet.func_199767_j().getRegistryName());
    }

    private static void bedsideCabinet(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider cabinet, IItemProvider log, IItemProvider planks) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)cabinet, (int)2).func_200472_a("LLL").func_200472_a("P P").func_200472_a("PPP").func_200462_a(Character.valueOf('L'), log).func_200462_a(Character.valueOf('P'), planks).func_200473_b("bedside_cabinet").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_planks", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)planks))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, cabinet.func_199767_j().getRegistryName());
    }

    private static void desk(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider desk, IItemProvider log, IItemProvider planks) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)desk, (int)2).func_200472_a("LLL").func_200472_a("P P").func_200472_a("P P").func_200462_a(Character.valueOf('L'), log).func_200462_a(Character.valueOf('P'), planks).func_200473_b("desk").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_planks", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)planks))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, desk.func_199767_j().getRegistryName());
    }

    private static void deskCabinet(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider desk, IItemProvider log, IItemProvider planks) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)desk, (int)2).func_200472_a("LLL").func_200472_a("PPP").func_200472_a("P P").func_200462_a(Character.valueOf('L'), log).func_200462_a(Character.valueOf('P'), planks).func_200473_b("desk_cabinet").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_planks", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)planks))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, desk.func_199767_j().getRegistryName());
    }

    private static void blinds(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider blinds, IItemProvider log) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)blinds, (int)2).func_200472_a("LLL").func_200472_a("SSS").func_200472_a("SSS").func_200462_a(Character.valueOf('L'), log).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.RODS_WOODEN).func_200473_b("blinds").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, blinds.func_199767_j().getRegistryName());
    }

    private static void upgradedFence(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider fence, IItemProvider log) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)fence, (int)12).func_200472_a("LSL").func_200472_a("LSL").func_200462_a(Character.valueOf('L'), log).func_200469_a(Character.valueOf('S'), (ITag)Tags.Items.RODS_WOODEN).func_200473_b("upgraded_fence").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, fence.func_199767_j().getRegistryName());
    }

    private static void upgradedGate(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider gate, IItemProvider log) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)gate, (int)2).func_200472_a("LGL").func_200462_a(Character.valueOf('L'), log).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.FENCE_GATES_WOODEN).func_200473_b("upgraded_gate").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_gate", (ICriterionInstance)RecipeGen.func_200409_a((ITag)Tags.Items.FENCE_GATES_WOODEN))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, gate.func_199767_j().getRegistryName());
    }

    private static void crate(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider crate, IItemProvider log, IItemProvider planks) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)crate, (int)2).func_200472_a("LPL").func_200472_a("P P").func_200472_a("LPL").func_200462_a(Character.valueOf('L'), log).func_200462_a(Character.valueOf('P'), planks).func_200473_b("crate").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_planks", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)planks))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, crate.func_199767_j().getRegistryName());
    }

    private static void parkBench(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider bench, IItemProvider log, IItemProvider planks) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)bench, (int)4).func_200472_a("PPP").func_200472_a("PPP").func_200472_a("L L").func_200462_a(Character.valueOf('L'), log).func_200462_a(Character.valueOf('P'), planks).func_200473_b("park_bench").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_planks", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)planks))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, bench.func_199767_j().getRegistryName());
    }

    private static void mailBox(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider mailbox, IItemProvider fence, String modId) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(modId)).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200470_a((IItemProvider)mailbox).func_200472_a("C").func_200472_a("F").func_200472_a("F").func_200469_a(Character.valueOf('C'), (ITag)Tags.Items.CHESTS_WOODEN).func_200462_a(Character.valueOf('F'), fence).func_200473_b("mail_box").func_200465_a("has_postbox", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)((IItemProvider)ModBlocks.POST_BOX.get()))).func_200465_a("has_chest", (ICriterionInstance)RecipeGen.func_200409_a((ITag)Tags.Items.CHESTS_WOODEN))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, mailbox.func_199767_j().getRegistryName());
    }

    private static void kitchenCounter(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider counter, IItemProvider log, IItemProvider planks) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)counter, (int)8).func_200472_a("LLL").func_200472_a("PPP").func_200472_a("PPP").func_200462_a(Character.valueOf('L'), log).func_200462_a(Character.valueOf('P'), planks).func_200473_b("kitchen_counter").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_planks", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)planks))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, counter.func_199767_j().getRegistryName());
    }

    private static void kitchenDrawer(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider counter, IItemProvider log, IItemProvider planks) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(log.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)counter, (int)4).func_200472_a("LLL").func_200472_a("PCP").func_200472_a("PPP").func_200462_a(Character.valueOf('L'), log).func_200462_a(Character.valueOf('P'), planks).func_200469_a(Character.valueOf('C'), (ITag)Tags.Items.CHESTS_WOODEN).func_200473_b("kitchen_drawer").func_200465_a("has_log", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)log)).func_200465_a("has_planks", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)planks)).func_200465_a("has_chest", (ICriterionInstance)RecipeGen.func_200409_a((ITag)Tags.Items.CHESTS_WOODEN))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, counter.func_199767_j().getRegistryName());
    }

    private static void kitchenSink(Consumer<IFinishedRecipe> recipeConsumer, IItemProvider sink, IItemProvider top, IItemProvider bottom) {
        ConditionalRecipe.builder().addCondition((ICondition)new ModLoadedCondition(bottom.func_199767_j().getRegistryName().func_110624_b())).addRecipe(arg_0 -> ((ShapedRecipeBuilder)ShapedRecipeBuilder.func_200468_a((IItemProvider)sink, (int)2).func_200472_a("CIC").func_200472_a("PBP").func_200472_a("PPP").func_200462_a(Character.valueOf('C'), top).func_200469_a(Character.valueOf('I'), (ITag)Tags.Items.INGOTS_IRON).func_200462_a(Character.valueOf('P'), bottom).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151133_ar).func_200473_b("kitchen_sink").func_200465_a("has_top", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)top)).func_200465_a("has_bottom", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)bottom)).func_200465_a("has_bucket", (ICriterionInstance)RecipeGen.func_200403_a((IItemProvider)Items.field_151133_ar))).func_200464_a(arg_0)).generateAdvancement().build(recipeConsumer, sink.func_199767_j().getRegistryName());
    }
}

