/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbteams.client;

import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbteams.FTBTeamsCommon;
import dev.ftb.mods.ftbteams.client.MyTeamScreen;
import dev.ftb.mods.ftbteams.data.ClientTeam;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import dev.ftb.mods.ftbteams.data.TeamMessage;
import dev.ftb.mods.ftbteams.event.ClientTeamPropertiesChangedEvent;
import dev.ftb.mods.ftbteams.event.TeamEvent;
import dev.ftb.mods.ftbteams.net.OpenGUIPacket;
import dev.ftb.mods.ftbteams.net.OpenGUIResponsePacket;
import dev.ftb.mods.ftbteams.property.TeamProperties;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public class FTBTeamsClient
extends FTBTeamsCommon {
    public static final ResourceLocation OPEN_GUI_ID = new ResourceLocation("ftbteams", "open_gui");

    public FTBTeamsClient() {
        CustomClickEvent.EVENT.register(event -> {
            if (event.getId().equals((Object)OPEN_GUI_ID)) {
                new OpenGUIPacket().sendToServer();
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.PASS;
        });
    }

    @Override
    public void openGui(OpenGUIResponsePacket res) {
        new MyTeamScreen(res).openGui();
    }

    @Override
    public void updateSettings(UUID id, TeamProperties properties) {
        ClientTeam team;
        if (ClientTeamManager.INSTANCE != null && (team = ClientTeamManager.INSTANCE.getTeam(id)) != null) {
            TeamProperties old = team.properties.copy();
            team.properties.updateFrom(properties);
            ((Consumer)TeamEvent.CLIENT_PROPERTIES_CHANGED.invoker()).accept(new ClientTeamPropertiesChangedEvent(team, old));
        }
    }

    @Override
    public void sendMessage(UUID from, ITextComponent text) {
        ClientTeamManager.INSTANCE.selfTeam.messageHistory.add(new TeamMessage(from, System.currentTimeMillis(), text));
        MyTeamScreen screen = (MyTeamScreen)((Object)ClientUtils.getCurrentGuiAs(MyTeamScreen.class));
        if (screen != null) {
            screen.chatPanel.refreshWidgets();
        }
    }
}

