/*
 * Decompiled with CFR 0.152.
 */
package customskinloader.fake;

import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import customskinloader.CustomSkinLoader;
import customskinloader.fake.FakeCapeBuffer;
import customskinloader.fake.FakeClientPlayer;
import customskinloader.fake.FakeSkinBuffer;
import customskinloader.fake.FakeThreadDownloadImageData;
import customskinloader.fake.itf.IFakeMinecraft;
import customskinloader.fake.itf.IFakeTextureManager_1;
import customskinloader.fake.itf.IFakeTextureManager_2;
import customskinloader.utils.HttpTextureUtil;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.Texture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.util.ResourceLocation;

public class FakeSkinManager {
    private static final ExecutorService THREAD_POOL = new ThreadPoolExecutor(CustomSkinLoader.config.threadPoolSize, CustomSkinLoader.config.threadPoolSize, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private final TextureManager textureManager;
    private final Map<ResourceLocation, MinecraftProfileTexture> modelCache = new HashMap<ResourceLocation, MinecraftProfileTexture>();

    public FakeSkinManager(TextureManager textureManagerInstance, File skinCacheDirectory, MinecraftSessionService sessionService) {
        this.textureManager = textureManagerInstance;
        HttpTextureUtil.defaultCacheDir = skinCacheDirectory;
    }

    public ResourceLocation loadSkin(MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType) {
        return this.loadSkin(profileTexture, textureType, null);
    }

    public ResourceLocation loadSkin(MinecraftProfileTexture profileTexture, MinecraftProfileTexture.Type textureType, SkinManager.SkinAvailableCallback skinAvailableCallback) {
        return this.loadSkin(profileTexture, HttpTextureUtil.toHttpTextureInfo(profileTexture.getUrl()), textureType, skinAvailableCallback);
    }

    private ResourceLocation loadSkin(MinecraftProfileTexture profileTexture, HttpTextureUtil.HttpTextureInfo info, MinecraftProfileTexture.Type textureType, SkinManager.SkinAvailableCallback skinAvailableCallback) {
        ResourceLocation resourcelocation = new ResourceLocation("skins/" + Hashing.sha1().hashUnencodedChars((CharSequence)info.hash).toString());
        if (((IFakeTextureManager_1)this.textureManager).getTexture(resourcelocation, null) != null) {
            FakeSkinManager.makeCallback(skinAvailableCallback, textureType, resourcelocation, this.modelCache.getOrDefault(resourcelocation, profileTexture));
        } else {
            SimpleTexture threaddownloadimagedata = FakeThreadDownloadImageData.createThreadDownloadImageData(info.cacheFile, info.url, DefaultPlayerSkin.func_177335_a(), new BaseBuffer(skinAvailableCallback, textureType, resourcelocation, profileTexture), textureType);
            if (skinAvailableCallback instanceof FakeClientPlayer.LegacyBuffer) {
                FakeClientPlayer.textureCache.put(resourcelocation, (ITextureObject)threaddownloadimagedata);
            }
            ((IFakeTextureManager_2)this.textureManager).func_229263_a_(resourcelocation, (Texture)threaddownloadimagedata);
        }
        return resourcelocation;
    }

    public void loadProfileTextures(GameProfile profile, SkinManager.SkinAvailableCallback skinAvailableCallback, boolean requireSecure) {
        THREAD_POOL.execute(() -> {
            HashMap map = Maps.newHashMap();
            map.putAll(CustomSkinLoader.loadProfile(profile));
            for (MinecraftProfileTexture.Type type : MinecraftProfileTexture.Type.values()) {
                MinecraftProfileTexture profileTexture = (MinecraftProfileTexture)map.get(type);
                if (profileTexture == null) continue;
                HttpTextureUtil.HttpTextureInfo info = HttpTextureUtil.toHttpTextureInfo(profileTexture.getUrl());
                FakeThreadDownloadImageData.downloadTexture(info.cacheFile, info.url);
                ((IFakeMinecraft)Minecraft.func_71410_x()).execute(() -> {
                    CustomSkinLoader.logger.debug("Loading type: " + type);
                    try {
                        this.loadSkin(profileTexture, info, type, skinAvailableCallback);
                    }
                    catch (Throwable t) {
                        CustomSkinLoader.logger.warning(t);
                    }
                });
            }
        });
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadSkinFromCache(GameProfile profile) {
        return CustomSkinLoader.loadProfileFromCache(profile);
    }

    private static void makeCallback(SkinManager.SkinAvailableCallback callback, MinecraftProfileTexture.Type type, ResourceLocation location, MinecraftProfileTexture texture) {
        if (callback != null) {
            callback.func_180521_a(type, location, texture);
        }
    }

    private class BaseBuffer
    implements IImageBuffer {
        private IImageBuffer buffer;
        private SkinManager.SkinAvailableCallback callback;
        private MinecraftProfileTexture.Type type;
        private ResourceLocation location;
        private MinecraftProfileTexture texture;

        public BaseBuffer(SkinManager.SkinAvailableCallback callback, MinecraftProfileTexture.Type type, ResourceLocation location, MinecraftProfileTexture texture) {
            switch (type) {
                case SKIN: {
                    this.buffer = new FakeSkinBuffer();
                    break;
                }
                case CAPE: {
                    this.buffer = new FakeCapeBuffer(location);
                }
            }
            this.callback = callback;
            this.type = type;
            this.location = location;
            this.texture = texture;
        }

        @Override
        public NativeImage func_195786_a(NativeImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).func_195786_a(image) : image;
        }

        @Override
        public BufferedImage func_78432_a(BufferedImage image) {
            return this.buffer instanceof FakeSkinBuffer ? ((FakeSkinBuffer)this.buffer).func_78432_a(image) : image;
        }

        @Override
        public void func_152634_a() {
            if (this.buffer != null) {
                this.buffer.func_152634_a();
                if ("auto".equals(this.texture.getMetadata("model")) && this.buffer instanceof FakeSkinBuffer) {
                    HashMap metadata = Maps.newHashMap();
                    String type = ((FakeSkinBuffer)this.buffer).judgeType();
                    metadata.put("model", type);
                    this.texture = new MinecraftProfileTexture(this.texture.getUrl(), (Map)metadata);
                    FakeSkinManager.this.modelCache.put(this.location, this.texture);
                }
            }
            FakeSkinManager.makeCallback(this.callback, this.type, this.location, this.texture);
        }
    }
}

