/*
 * Decompiled with CFR 0.152.
 */
package customskinloader;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import customskinloader.Logger;
import customskinloader.config.Config;
import customskinloader.config.SkinSiteProfile;
import customskinloader.loader.ProfileLoader;
import customskinloader.profile.DynamicSkullManager;
import customskinloader.profile.ModelManager0;
import customskinloader.profile.ProfileCache;
import customskinloader.profile.UserProfile;
import customskinloader.utils.MinecraftUtil;
import java.io.File;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class CustomSkinLoader {
    public static final String CustomSkinLoader_VERSION = "14.13";
    public static final String CustomSkinLoader_FULL_VERSION = "14.13-SNAPSHOT-282";
    public static final int CustomSkinLoader_BUILD_NUMBER = Integer.parseInt("282");
    public static final File DATA_DIR = new File(MinecraftUtil.getMinecraftDataDir(), "CustomSkinLoader");
    public static final File LOG_FILE = new File(DATA_DIR, "CustomSkinLoader.log");
    public static final File CONFIG_FILE = new File(DATA_DIR, "CustomSkinLoader.json");
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Logger logger = CustomSkinLoader.initLogger();
    public static final Config config = Config.loadConfig0();
    private static final ProfileCache profileCache = new ProfileCache();
    private static final DynamicSkullManager dynamicSkullManager = new DynamicSkullManager();
    private static final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
    private static final ThreadFactory customFactory = r -> {
        Thread t = defaultFactory.newThread(r);
        if (r instanceof Thread) {
            t.setName(((Thread)r).getName());
        }
        return t;
    };
    private static final ThreadPoolExecutor threadPool = new ThreadPoolExecutor(CustomSkinLoader.config.threadPoolSize, CustomSkinLoader.config.threadPoolSize, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(333), customFactory, new ThreadPoolExecutor.DiscardOldestPolicy());

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadProfile(GameProfile gameProfile) {
        UserProfile profile;
        String username = gameProfile.getName();
        String credential = MinecraftUtil.getCredential(gameProfile);
        if (username == null) {
            logger.warning("Could not load profile: username is null.");
            return Maps.newHashMap();
        }
        String tempName = Thread.currentThread().getName();
        Thread.currentThread().setName(username);
        if (profileCache.isReady(credential)) {
            logger.info("Cached profile will be used.");
            profile = profileCache.getProfile(credential);
            if (profile == null) {
                logger.warning("(!Cached Profile is empty!) Expiry:" + profileCache.getExpiry(credential));
                if (profileCache.isExpired(credential)) {
                    profile = CustomSkinLoader.loadProfile0(gameProfile);
                }
            } else {
                logger.info(profile.toString(profileCache.getExpiry(credential)));
            }
        } else {
            profileCache.setLoading(credential, true);
            profile = CustomSkinLoader.loadProfile0(gameProfile);
        }
        Thread.currentThread().setName(tempName);
        return ModelManager0.fromUserProfile(profile);
    }

    public static UserProfile loadProfile0(GameProfile gameProfile) {
        String username = gameProfile.getName();
        String credential = MinecraftUtil.getCredential(gameProfile);
        profileCache.setLoading(credential, true);
        logger.info("Loading " + username + "'s profile.");
        if (CustomSkinLoader.config.loadlist == null || CustomSkinLoader.config.loadlist.isEmpty()) {
            logger.info("LoadList is Empty.");
            return null;
        }
        UserProfile profile0 = new UserProfile();
        for (int i = 0; i < CustomSkinLoader.config.loadlist.size(); ++i) {
            UserProfile profile;
            block11: {
                SkinSiteProfile ssp = CustomSkinLoader.config.loadlist.get(i);
                logger.info(i + 1 + "/" + CustomSkinLoader.config.loadlist.size() + " Try to load profile from '" + ssp.name + "'.");
                ProfileLoader.IProfileLoader loader = ProfileLoader.LOADERS.get(ssp.type.toLowerCase());
                if (loader == null) {
                    logger.info("Type '" + ssp.type + "' is not defined.");
                    continue;
                }
                profile = null;
                try {
                    profile = loader.loadProfile(ssp, gameProfile);
                }
                catch (Exception e) {
                    logger.warning("Exception occurs while loading.");
                    logger.warning(e);
                    if (e.getCause() == null) break block11;
                    logger.warning("Caused By:");
                    logger.warning(e.getCause());
                }
            }
            if (profile == null) continue;
            if (!CustomSkinLoader.config.forceLoadAllTextures) {
                profile0 = profile;
                break;
            }
            profile0.mix(profile);
            if (profile0.isFull()) break;
        }
        if (!profile0.isEmpty()) {
            logger.info(username + "'s profile loaded.");
            if (!CustomSkinLoader.config.enableCape) {
                profile0.capeUrl = null;
            }
            profileCache.updateCache(credential, profile0);
            profileCache.setLoading(credential, false);
            logger.info(profile0.toString(profileCache.getExpiry(credential)));
            return profile0;
        }
        logger.info(username + "'s profile not found in load list.");
        if (CustomSkinLoader.config.enableLocalProfileCache) {
            UserProfile profile = profileCache.getLocalProfile(credential);
            if (profile == null) {
                logger.info(username + "'s LocalProfile not found.");
            } else {
                profileCache.updateCache(credential, profile, false);
                profileCache.setLoading(credential, false);
                logger.info(username + "'s LocalProfile will be used.");
                logger.info(profile.toString(profileCache.getExpiry(credential)));
                return profile;
            }
        }
        profileCache.setLoading(credential, false);
        return null;
    }

    public static Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> loadProfileFromCache(GameProfile gameProfile) {
        String username = gameProfile.getName();
        String credential = MinecraftUtil.getCredential(gameProfile);
        if (username == null || credential == null) {
            return dynamicSkullManager.getTexture(gameProfile);
        }
        if (CustomSkinLoader.config.forceUpdateSkull ? profileCache.isReady(credential) : profileCache.isExist(credential)) {
            UserProfile profile = profileCache.getProfile(credential);
            return ModelManager0.fromUserProfile(profile);
        }
        if (!profileCache.isLoading(credential)) {
            profileCache.setLoading(credential, true);
            Runnable loadThread = () -> {
                String tempName = Thread.currentThread().getName();
                Thread.currentThread().setName(username + "'s skull");
                CustomSkinLoader.loadProfile0(gameProfile);
                Thread.currentThread().setName(tempName);
            };
            if (CustomSkinLoader.config.forceUpdateSkull) {
                new Thread(loadThread).start();
            } else {
                threadPool.execute(loadThread);
            }
        }
        return Maps.newHashMap();
    }

    private static Logger initLogger() {
        Logger logger = new Logger(LOG_FILE);
        logger.info("CustomSkinLoader 14.13-SNAPSHOT-282");
        logger.info("DataDir: " + DATA_DIR.getAbsolutePath());
        logger.info("Operating System: " + System.getProperty("os.name") + " (" + System.getProperty("os.arch") + ") version " + System.getProperty("os.version"));
        logger.info("Java Version: " + System.getProperty("java.version") + ", " + System.getProperty("java.vendor"));
        logger.info("Java VM Version: " + System.getProperty("java.vm.name") + " (" + System.getProperty("java.vm.info") + "), " + System.getProperty("java.vm.vendor"));
        logger.info("Minecraft: " + MinecraftUtil.getMinecraftMainVersion() + "(" + MinecraftUtil.getMinecraftVersionText() + ")");
        return logger;
    }
}

