/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.mekanism.slurries;

import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryBuilder;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.compat.mekanism.api.slurries.IMaterialFormSlurry;
import thelm.jaopca.compat.mekanism.api.slurries.ISlurryFormSettings;
import thelm.jaopca.utils.ApiImpl;

public class JAOPCASlurry
extends Slurry
implements IMaterialFormSlurry {
    private final IForm form;
    private final IMaterial material;
    protected final ISlurryFormSettings settings;
    protected boolean isHidden;

    public JAOPCASlurry(IForm form, IMaterial material, ISlurryFormSettings settings) {
        super(SlurryBuilder.builder((ResourceLocation)new ResourceLocation("jaopca", "slurry/" + material.getModelType() + '/' + form.getName())));
        this.form = form;
        this.material = material;
        this.settings = settings;
        this.isHidden = settings.getIsHidden();
    }

    @Override
    public IForm getForm() {
        return this.form;
    }

    @Override
    public IMaterial getMaterial() {
        return this.material;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public int getTint() {
        return 0xFFFFFF & this.material.getColor();
    }

    public ITextComponent getTextComponent() {
        return ApiImpl.INSTANCE.currentLocalizer().localizeMaterialForm("slurry.jaopca." + this.form.getName(), this.material, this.getTranslationKey());
    }
}

