/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crossroads;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.crossroads.CrossroadsHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"crossroads"})
public class CrossroadsCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(Arrays.asList("copper", "gold", "iron", "tin"));
    private static final Set<String> TO_MOLTEN_BLACKLIST = new TreeSet<String>(Arrays.asList("copper", "copshowium", "gold", "iron", "tin"));
    private static final Set<String> TO_MATERIAL_BLACKLIST = new TreeSet<String>(Arrays.asList("copper", "copshowium", "gold", "iron", "tin"));
    private static Set<String> configToDustBlacklist = new TreeSet<String>();
    private static Set<String> configToMoltenBlacklist = new TreeSet<String>();
    private static Set<String> configToMaterialBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "crossroads_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have mill recipes added."), configToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toMoltenMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have crucible recipes added."), configToMoltenBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toMaterialMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have fluid cooling recipes added."), configToMaterialBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        CrossroadsHelper helper = CrossroadsHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation dustLocation;
            ResourceLocation materialLocation;
            MaterialType type = material.getType();
            String name = material.getName();
            if (!(ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)type)) || TO_DUST_BLACKLIST.contains(name) || configToDustBlacklist.contains(name))) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                dustLocation = miscHelper.getTagLocation("dusts", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(dustLocation)) {
                    helper.registerMillRecipe(new ResourceLocation("jaopca", "crossroads.material_to_dust." + material.getName()), materialLocation, dustLocation, 1);
                }
            }
            if (!(ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)type)) || TO_MOLTEN_BLACKLIST.contains(name) || configToMoltenBlacklist.contains(name))) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                dustLocation = miscHelper.getTagLocation("dusts", material.getName());
                ResourceLocation nuggetLocation = miscHelper.getTagLocation("nuggets", material.getName());
                ResourceLocation moltenLocation = miscHelper.getTagLocation("molten", material.getName());
                if (((JAOPCAApi)api).getFluidTags().contains(moltenLocation)) {
                    helper.registerCrucibleRecipe(new ResourceLocation("jaopca", "crossroads.material_to_molten." + material.getName()), materialLocation, moltenLocation, 144);
                    if (((JAOPCAApi)api).getItemTags().contains(dustLocation)) {
                        helper.registerCrucibleRecipe(new ResourceLocation("jaopca", "crossroads.dust_to_molten." + material.getName()), dustLocation, moltenLocation, 144);
                    }
                    if (((JAOPCAApi)api).getItemTags().contains(nuggetLocation)) {
                        helper.registerCrucibleRecipe(new ResourceLocation("jaopca", "crossroads.nugget_to_molten." + material.getName()), nuggetLocation, moltenLocation, 16);
                    }
                }
            }
            if (ArrayUtils.contains((Object[])MaterialType.DUSTS, (Object)((Object)type)) || TO_MATERIAL_BLACKLIST.contains(name) || configToMaterialBlacklist.contains(name)) continue;
            ResourceLocation moltenLocation = miscHelper.getTagLocation("molten", material.getName());
            ResourceLocation materialLocation2 = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            if (!((JAOPCAApi)api).getFluidTags().contains(moltenLocation)) continue;
            helper.registerFluidCoolingRecipe(new ResourceLocation("jaopca", "crossroads.molten_to_material." + material.getName()), moltenLocation, 144, materialLocation2, 1, 1500.0f, 100.0f);
        }
    }
}

