/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.crafttweaker;

import com.blamejared.crafttweaker.api.annotations.ZenRegister;
import java.util.TreeMap;
import org.openzen.zencode.java.ZenCodeType;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.compat.crafttweaker.Form;
import thelm.jaopca.compat.crafttweaker.Material;
import thelm.jaopca.forms.FormHandler;
import thelm.jaopca.modules.ModuleHandler;

@ZenRegister
@ZenCodeType.Name(value="mods.jaopca.Module")
public class Module {
    private static final TreeMap<IModule, Module> MODULE_WRAPPERS = new TreeMap();
    private final IModule module;
    private final IModuleData moduleData;

    public static Module getModuleWrapper(IModule form) {
        return MODULE_WRAPPERS.computeIfAbsent(form, Module::new);
    }

    private Module(IModule module) {
        this.module = module;
        this.moduleData = ModuleHandler.getModuleData(module);
    }

    public IModule getInternal() {
        return this.module;
    }

    @ZenCodeType.Getter(value="name")
    public String getName() {
        return this.module.getName();
    }

    @ZenCodeType.Getter(value="materialTypes")
    public String[] getMaterialTypes() {
        return (String[])this.module.getMaterialTypes().stream().map(MaterialType::getName).toArray(String[]::new);
    }

    @ZenCodeType.Getter(value="materials")
    public Material[] getMaterials() {
        return (Material[])this.moduleData.getMaterials().stream().map(Material::getMaterialWrapper).toArray(Material[]::new);
    }

    @ZenCodeType.Method
    public boolean containsMaterial(Material material) {
        return this.moduleData.getMaterials().contains(material.getInternal());
    }

    @ZenCodeType.Getter(value="forms")
    public Form[] getForms() {
        return (Form[])FormHandler.getForms().stream().filter(f -> f.getModule() == this.module).map(Form::getFormWrapper).toArray(Form[]::new);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Module)) {
            return false;
        }
        Module other = (Module)obj;
        return this.module == other.module;
    }

    public int hashCode() {
        return this.module.hashCode() + 5;
    }
}

