/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.bloodmagic.recipes;

import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.compat.bloodmagic.BloodMagicHelper;
import thelm.jaopca.utils.MiscHelper;
import wayoftime.bloodmagic.recipe.RecipeARC;
import wayoftime.bloodmagic.recipe.helper.FluidStackIngredient;

public class ARCRecipeSupplier
implements Supplier<RecipeARC> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object tool;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object[] output;
    public final Object fluidOutput;
    public final int fluidOutputAmount;
    public final boolean consumeInput;

    public ARCRecipeSupplier(ResourceLocation key, Object input, Object tool, Object[] output, boolean consumeInput) {
        this(key, input, tool, null, 0, output, null, 0, consumeInput);
    }

    public ARCRecipeSupplier(ResourceLocation key, Object input, Object tool, Object fluidInput, int fluidInputAmount, Object[] output, Object fluidOutput, int fluidOutputAmount, boolean consumeInput) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.tool = tool;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.output = output;
        this.fluidOutput = fluidOutput;
        this.fluidOutputAmount = fluidOutputAmount;
        this.consumeInput = consumeInput;
    }

    @Override
    public RecipeARC get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        Ingredient ingTool = MiscHelper.INSTANCE.getIngredient(this.tool);
        if (ingTool.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.tool);
        }
        FluidStackIngredient fluidIng = BloodMagicHelper.INSTANCE.getFluidStackIngredient(this.fluidInput, this.fluidInputAmount);
        ItemStack result = null;
        ArrayList<Pair> chanceOutputs = new ArrayList<Pair>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Double chance = 1.0;
            if (i < this.output.length && this.output[i] instanceof Double) {
                chance = (Double)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            if (result == null) {
                result = stack;
                continue;
            }
            chanceOutputs.add(Pair.of((Object)stack, (Object)chance));
        }
        if (result == null) {
            LOGGER.warn("No output in recipe {}", (Object)this.key);
            result = ItemStack.field_190927_a;
        }
        FluidStack fluidResult = MiscHelper.INSTANCE.getFluidStack(this.fluidOutput, this.fluidOutputAmount);
        return new RecipeARC(this.key, ing, ingTool, fluidIng, result, chanceOutputs, fluidResult, this.consumeInput);
    }
}

