/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.appliedenergistics2.recipes;

import appeng.core.AEConfig;
import appeng.recipes.handlers.GrinderOptionalResult;
import appeng.recipes.handlers.GrinderRecipe;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.utils.MiscHelper;

public class GrinderRecipeSupplier
implements Supplier<GrinderRecipe> {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final int turns;
    public final Object[] extraOutputs;

    public GrinderRecipeSupplier(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, int turns, Object ... extraOutputs) {
        this(key, "", input, inputCount, output, outputCount, turns, extraOutputs);
    }

    public GrinderRecipeSupplier(ResourceLocation key, String group, Object input, int inputCount, Object output, int outputCount, int turns, Object ... extraOutputs) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.turns = turns;
        this.extraOutputs = extraOutputs;
    }

    @Override
    public GrinderRecipe get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing.func_203189_d()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.func_190926_b()) {
            LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, this.output);
        }
        ArrayList<GrinderOptionalResult> extras = new ArrayList<GrinderOptionalResult>();
        int i = 0;
        while (i < this.extraOutputs.length) {
            ItemStack extraStack;
            Object out = this.extraOutputs[i];
            Integer count = 1;
            if (++i < this.extraOutputs.length && this.extraOutputs[i] instanceof Integer) {
                count = (Integer)this.extraOutputs[i];
                ++i;
            }
            Float chance = Float.valueOf(AEConfig.instance().getOreDoublePercentage() / 100.0f);
            if (i < this.extraOutputs.length && this.extraOutputs[i] instanceof Float) {
                chance = (Float)this.extraOutputs[i];
                ++i;
            }
            if ((extraStack = MiscHelper.INSTANCE.getItemStack(out, count)).func_190926_b()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
            }
            extras.add(new GrinderOptionalResult(chance.floatValue(), extraStack));
        }
        return new GrinderRecipe(this.key, this.group, ing, this.inputCount, stack, this.turns, extras);
    }
}

