/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.advancedrocketry;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.fluid.Fluids;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import org.apache.commons.lang3.ArrayUtils;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.advancedrocketry.AdvancedRocketryHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"advancedrocketry"})
public class AdvancedRocketryCompatModule
implements IModule {
    private static final Set<String> TO_STICK_BLACKLIST = new TreeSet<String>(Arrays.asList("copper", "iridium", "iron", "steel", "titanium", "titaniumaluminide", "titaniumiridium"));
    private static final Set<String> TO_PLATE_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "copper", "gold", "iridium", "iron", "silicon", "steel", "tin", "titanium", "titaniumaluminide", "titaniumiridium"));
    private static final Set<String> TO_SHEET_BLACKLIST = new TreeSet<String>(Arrays.asList("aluminum", "aluminium", "copper", "gold", "iridium", "iron", "steel", "titanium", "titaniumaluminide", "titaniumiridium"));
    private static Set<String> configToStickBlacklist = new TreeSet<String>();
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configToSheetBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "advancedrocketry_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toStickMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have lathe recipes added."), configToStickBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have rolling machine to plate recipes added."), configToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toSheetMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have rolling machine to sheet recipes added."), configToSheetBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        AdvancedRocketryHelper helper = AdvancedRocketryHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation materialLocation;
            MaterialType type = material.getType();
            String name = material.getName();
            if (ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) && !TO_STICK_BLACKLIST.contains(name) && !configToStickBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation stickLocation = miscHelper.getTagLocation("sticks", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(stickLocation)) {
                    helper.registerLatheRecipe(new ResourceLocation("jaopca", "advancedrocketry.material_to_stick." + material.getName()), new Object[]{materialLocation}, new Object[]{stickLocation, 2}, 300, 20);
                }
            }
            if (ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) && !TO_PLATE_BLACKLIST.contains(name) && !configToPlateBlacklist.contains(name)) {
                materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
                ResourceLocation plateLocation = miscHelper.getTagLocation("plates", material.getName());
                if (((JAOPCAApi)api).getItemTags().contains(plateLocation)) {
                    helper.registerRollingMachineRecipe(new ResourceLocation("jaopca", "advancedrocketry.material_to_plate." + material.getName()), new Object[]{materialLocation}, Fluids.field_204546_a, 10, new Object[]{plateLocation}, 300, 20);
                }
            }
            if (!ArrayUtils.contains((Object[])MaterialType.INGOTS, (Object)((Object)type)) || TO_SHEET_BLACKLIST.contains(name) || configToSheetBlacklist.contains(name)) continue;
            ResourceLocation plateLocation = miscHelper.getTagLocation("plates", material.getName());
            ResourceLocation sheetLocation = miscHelper.getTagLocation("sheets", material.getName());
            if (!((JAOPCAApi)api).getItemTags().contains(plateLocation) || !((JAOPCAApi)api).getItemTags().contains(sheetLocation)) continue;
            helper.registerRollingMachineRecipe(new ResourceLocation("jaopca", "advancedrocketry.material_to_sheet." + material.getName()), new Object[]{plateLocation}, Fluids.field_204546_a, 10, new Object[]{sheetLocation}, 300, 20);
        }
    }
}

