/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.network;

import io.netty.buffer.ByteBuf;
import ipsis.woot.modules.factory.FormedSetup;
import ipsis.woot.modules.factory.blocks.HeartContainer;
import ipsis.woot.modules.factory.blocks.HeartRecipe;
import ipsis.woot.modules.factory.client.ClientFactorySetup;
import ipsis.woot.modules.factory.perks.Helper;
import ipsis.woot.modules.factory.perks.Perk;
import ipsis.woot.simulator.MobSimulator;
import ipsis.woot.simulator.SimulatedMobDropSummary;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.NetworkHelper;
import ipsis.woot.util.oss.NetworkTools;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;

public class HeartStaticDataReply {
    public FormedSetup formedSetup;
    public HeartRecipe recipe;
    public ClientFactorySetup clientFactorySetup;

    public HeartStaticDataReply() {
    }

    public HeartStaticDataReply(FormedSetup formedSetup, HeartRecipe recipe) {
        this.formedSetup = formedSetup;
        this.recipe = recipe;
    }

    public static HeartStaticDataReply fromBytes(ByteBuf buf) {
        HeartStaticDataReply pkt = new HeartStaticDataReply();
        pkt.clientFactorySetup = ClientFactorySetup.fromBytes(buf);
        return pkt;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.formedSetup.getTier().ordinal());
        buf.writeInt(this.formedSetup.getCellCapacity());
        buf.writeInt(this.formedSetup.getCellFluidAmount());
        buf.writeInt(this.formedSetup.getLootingLevel());
        buf.writeInt(this.formedSetup.getExotic().ordinal());
        buf.writeInt(this.recipe.getNumTicks());
        buf.writeInt(this.recipe.getNumUnits());
        if (this.formedSetup.getAllPerks().containsKey((Object)Perk.Group.TIER_SHARD)) {
            buf.writeInt(this.formedSetup.getPerkTierShardValue());
            buf.writeDouble(this.formedSetup.getShardDropChance());
            double full = this.formedSetup.getBasicShardWeight() + this.formedSetup.getAdvancedShardWeight() + this.formedSetup.getEliteShardWeight();
            buf.writeDouble(100.0 / full * (double)this.formedSetup.getBasicShardWeight());
            buf.writeDouble(100.0 / full * (double)this.formedSetup.getAdvancedShardWeight());
            buf.writeDouble(100.0 / full * (double)this.formedSetup.getEliteShardWeight());
        } else {
            buf.writeInt(0);
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
        }
        buf.writeInt(this.formedSetup.getAllMobs().size());
        for (FakeMob fakeMob : this.formedSetup.getAllMobs()) {
            NetworkTools.writeString(buf, fakeMob.toString());
            buf.writeInt(this.formedSetup.getAllMobParams().get((Object)fakeMob).baseSpawnTicks);
            buf.writeInt(this.formedSetup.getAllMobParams().get((Object)fakeMob).baseMassCount);
            buf.writeInt(this.formedSetup.getAllMobParams().get((Object)fakeMob).baseFluidCost);
            buf.writeInt(this.formedSetup.getAllMobParams().get(fakeMob).getPerkRateValue());
            buf.writeInt(this.formedSetup.getAllMobParams().get(fakeMob).getPerkEfficiencyValue());
            buf.writeInt(this.formedSetup.getAllMobParams().get(fakeMob).getMobCount(this.formedSetup.getAllPerks().containsKey((Object)Perk.Group.MASS), this.formedSetup.hasMassExotic()));
            buf.writeInt(this.formedSetup.getAllMobParams().get(fakeMob).getPerkXpValue());
            buf.writeInt(this.formedSetup.getAllMobParams().get(fakeMob).getPerkHeadlessValue());
            List<SimulatedMobDropSummary> drops = MobSimulator.getInstance().getDropSummary(fakeMob);
            buf.writeInt(drops.size());
            for (SimulatedMobDropSummary drop : drops) {
                ItemStack itemStack = drop.itemStack.func_77946_l();
                itemStack.func_190920_e((int)(drop.chanceToDrop[this.formedSetup.getLootingLevel()] * 1000.0f));
                NetworkTools.writeItemStack(buf, itemStack);
                buf.writeFloat(drop.chanceToDrop[this.formedSetup.getLootingLevel()]);
            }
        }
        buf.writeBoolean(this.formedSetup.isPerkCapped());
        buf.writeInt(this.formedSetup.getAllPerks().size());
        for (Map.Entry entry : this.formedSetup.getAllPerks().entrySet()) {
            Perk perk = Helper.getPerk((Perk.Group)((Object)entry.getKey()), (Integer)entry.getValue());
            buf.writeInt(perk.ordinal());
        }
        buf.writeInt(this.recipe.recipeItems.size());
        this.recipe.recipeItems.forEach(i -> NetworkTools.writeItemStack(buf, i));
        buf.writeInt(this.recipe.recipeFluids.size());
        this.recipe.recipeFluids.forEach(i -> NetworkHelper.writeFluidStack(buf, i));
    }

    public void handle(Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> this.lambda$null$3((Supplier)ctx)));
    }

    private /* synthetic */ Runnable lambda$null$3(Supplier ctx) {
        return () -> this.lambda$null$2((Supplier)ctx);
    }

    private /* synthetic */ void lambda$null$2(Supplier ctx) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (player.field_71070_bA instanceof HeartContainer) {
            ((HeartContainer)player.field_71070_bA).handleStaticDataReply(this.clientFactorySetup);
        }
        ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
    }
}

