/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.modules.factory.generators;

import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import ipsis.woot.Woot;
import ipsis.woot.util.FakeMob;
import ipsis.woot.util.helper.RandomHelper;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.util.JSONUtils;

public class SkullGenerator {
    private HashMap<FakeMob, ItemStack> skulls = new HashMap();

    public void loadFromConfig(List<String> config) {
        this.skulls.clear();
        for (String s : config) {
            String[] parts = s.split(",");
            if (parts.length != 2) {
                Woot.setup.getLogger().error(s + " == INVALID");
                continue;
            }
            FakeMob fakeMob = new FakeMob(parts[0]);
            if (!fakeMob.isValid()) {
                Woot.setup.getLogger().error(s + " == INVALID (mob {})", (Object)parts[0]);
                continue;
            }
            try {
                ItemStack itemStack;
                JsonObject jsonObject = JSONUtils.func_212745_a((String)parts[1]);
                if (!jsonObject.isJsonObject() || (itemStack = ShapedRecipe.func_199798_a((JsonObject)jsonObject)).func_190926_b()) continue;
                Woot.setup.getLogger().info("SkullGenerator: {} -> {}", (Object)fakeMob, (Object)itemStack);
                this.skulls.put(fakeMob, itemStack);
            }
            catch (JsonParseException e) {
                Woot.setup.getLogger().error("SkullGenerator: invalid head {}", (Object)parts[1]);
            }
        }
    }

    public ItemStack getSkullDrop(FakeMob fakeMob, float chance) {
        ItemStack skull = this.skulls.getOrDefault(fakeMob, ItemStack.field_190927_a);
        if (!skull.func_190926_b() && RandomHelper.rollPercentage(chance, "getSkullDrop")) {
            return skull.func_77946_l();
        }
        return ItemStack.field_190927_a;
    }
}

