/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.crafting;

import ipsis.woot.crafting.InfuserRecipeBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class InfuserRecipe
implements IRecipe<IInventory> {
    private final Ingredient ingredient;
    private final Ingredient augment;
    private final int augmentCount;
    private final FluidStack fluid;
    private final Item result;
    private final int count;
    private final int energy;
    private final ResourceLocation id;
    private final IRecipeType<?> type;
    public static final IRecipeType<InfuserRecipe> INFUSER_TYPE = IRecipeType.func_222147_a((String)"woot:infuser");
    private List<List<ItemStack>> inputs = new ArrayList<List<ItemStack>>();
    private static List<ItemStack> validInputs = new ArrayList<ItemStack>();
    private static List<ItemStack> validAugments = new ArrayList<ItemStack>();
    private static List<FluidStack> validFluids = new ArrayList<FluidStack>();

    public InfuserRecipe(ResourceLocation id, Ingredient ingredient, Ingredient augment, int augmentCount, FluidStack fluidStack, IItemProvider result, int count, int energy) {
        this.id = id;
        this.ingredient = ingredient;
        this.augment = augment;
        this.augmentCount = augmentCount;
        this.fluid = fluidStack;
        this.result = result.func_199767_j();
        this.count = count;
        this.type = INFUSER_TYPE;
        this.energy = energy;
        this.inputs.add(Arrays.asList(ingredient.func_193365_a()));
        if (this.hasAugment()) {
            List<ItemStack> stacks = Arrays.asList(augment.func_193365_a());
            for (ItemStack stack : stacks) {
                stack.func_190920_e(augmentCount);
            }
            this.inputs.add(stacks);
        }
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public boolean hasAugment() {
        return this.augment != Ingredient.field_193370_a;
    }

    public Ingredient getAugment() {
        return this.augment;
    }

    public int getAugmentCount() {
        return this.augmentCount;
    }

    public ItemStack getOutput() {
        return new ItemStack((IItemProvider)this.result, this.count);
    }

    public FluidStack getFluidInput() {
        return this.fluid;
    }

    public int getEnergy() {
        return this.energy;
    }

    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public static void clearValidInputs() {
        validInputs.clear();
    }

    public static void addValidInput(ItemStack itemStack) {
        validInputs.add(itemStack);
    }

    public static boolean isValidInput(ItemStack itemStack) {
        for (ItemStack i : validInputs) {
            if (!i.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void clearValidAugments() {
        validAugments.clear();
    }

    public static void addValidAugment(ItemStack itemStack) {
        validAugments.add(itemStack);
    }

    public static boolean isValidAugment(ItemStack itemStack) {
        for (ItemStack i : validAugments) {
            if (!i.func_77969_a(itemStack)) continue;
            return true;
        }
        return false;
    }

    public static void clearValidFluids() {
        validFluids.clear();
    }

    public static void addValidFluid(FluidStack fluidStack) {
        validFluids.add(fluidStack);
    }

    public static boolean isValidFluid(FluidStack fluidStack) {
        for (FluidStack f : validFluids) {
            if (!f.isFluidEqual(fluidStack)) continue;
            return true;
        }
        return false;
    }

    public boolean func_77569_a(IInventory inv, World worldIn) {
        ItemStack invStack;
        if (!this.ingredient.test(inv.func_70301_a(0))) {
            return false;
        }
        return this.augment == Ingredient.field_193370_a || this.augment.test(invStack = inv.func_70301_a(1)) && this.augmentCount <= invStack.func_190916_E();
    }

    public ItemStack func_77572_b(IInventory inv) {
        return null;
    }

    public boolean func_194133_a(int width, int height) {
        return false;
    }

    public ItemStack func_77571_b() {
        return ItemStack.field_190927_a;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return InfuserRecipeBuilder.SERIALIZER;
    }

    public IRecipeType<?> func_222127_g() {
        return this.type;
    }
}

