/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book.text;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.event.HoverEvent;
import vazkii.patchouli.client.book.gui.GuiBook;
import vazkii.patchouli.client.book.text.Span;
import vazkii.patchouli.common.book.Book;

public class Word {
    private final Book book;
    private final GuiBook gui;
    private final ITextComponent text;
    private final List<Word> linkCluster;
    private final Supplier<Boolean> onClick;
    public final int x;
    public final int y;
    public final int width;
    public final int height;

    public Word(GuiBook gui, Span span, IFormattableTextComponent text, int x, int y, int strWidth, List<Word> cluster) {
        this.book = gui.book;
        this.gui = gui;
        this.x = x;
        this.y = y;
        this.width = strWidth;
        this.height = 8;
        this.onClick = span.onClick;
        this.linkCluster = cluster;
        if (!span.tooltip.getString().isEmpty()) {
            text = text.func_240700_a_(s -> s.func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)span.tooltip)));
        }
        this.text = text;
    }

    public void render(MatrixStack ms, FontRenderer font, Style styleOverride, int mouseX, int mouseY) {
        IFormattableTextComponent toRender = this.text.func_230532_e_().func_240703_c_(styleOverride);
        if (this.isClusterHovered(mouseX, mouseY)) {
            if (this.onClick != null) {
                toRender.func_240700_a_(s -> s.func_240718_a_(Color.func_240743_a_((int)this.book.linkHoverColor)));
            }
            this.gui.func_238653_a_(ms, this.text.func_150256_b(), (int)this.gui.getRelativeX(mouseX), (int)this.gui.getRelativeY(mouseY));
        }
        font.func_238422_b_(ms, toRender.func_241878_f(), (float)this.x, (float)this.y, -1);
    }

    public boolean click(double mouseX, double mouseY, int mouseButton) {
        if (this.onClick != null && mouseButton == 0 && this.isHovered(mouseX, mouseY)) {
            return this.onClick.get();
        }
        return false;
    }

    private boolean isHovered(double mouseX, double mouseY) {
        return this.gui.isMouseInRelativeRange(mouseX, mouseY, this.x, this.y, this.width, this.height);
    }

    private boolean isClusterHovered(double mouseX, double mouseY) {
        if (this.linkCluster == null) {
            return this.isHovered(mouseX, mouseY);
        }
        for (Word w : this.linkCluster) {
            if (!w.isHovered(mouseX, mouseY)) continue;
            return true;
        }
        return false;
    }
}

