/*
 * Decompiled with CFR 0.152.
 */
package xiroc.dungeoncrawl.util;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Unit;
import xiroc.dungeoncrawl.DungeonCrawl;
import xiroc.dungeoncrawl.config.Config;
import xiroc.dungeoncrawl.dungeon.DungeonType;
import xiroc.dungeoncrawl.dungeon.model.DungeonModels;
import xiroc.dungeoncrawl.dungeon.model.ModelBlockDefinition;
import xiroc.dungeoncrawl.dungeon.model.ModelPools;
import xiroc.dungeoncrawl.dungeon.monster.RandomEquipment;
import xiroc.dungeoncrawl.dungeon.monster.RandomMonster;
import xiroc.dungeoncrawl.dungeon.monster.RandomPotionEffect;
import xiroc.dungeoncrawl.dungeon.monster.SpawnRates;
import xiroc.dungeoncrawl.dungeon.treasure.RandomItems;
import xiroc.dungeoncrawl.theme.Theme;
import xiroc.dungeoncrawl.util.Updateable;

public class ResourceReloadHandler
implements IFutureReloadListener {
    public static final ArrayList<Updateable> UPDATEABLES = new ArrayList();

    public void reload(IResourceManager resourceManager) {
        DungeonCrawl.LOGGER.info("Loading data...");
        UPDATEABLES.clear();
        DungeonModels.load(resourceManager);
        ModelPools.load(resourceManager);
        DungeonType.load(resourceManager);
        Theme.loadJson(resourceManager);
        SpawnRates.loadJson(resourceManager);
        RandomItems.loadJson(resourceManager);
        RandomMonster.loadJson(resourceManager);
        RandomEquipment.loadJson(resourceManager);
        RandomPotionEffect.loadJson(resourceManager);
        if (((Boolean)Config.ENABLE_TOOLS.get()).booleanValue()) {
            ModelBlockDefinition.loadJson(resourceManager);
        }
        DungeonCrawl.LOGGER.debug("Finishing...");
        UPDATEABLES.forEach(Updateable::update);
        UPDATEABLES.clear();
        DungeonCrawl.LOGGER.info("Done.");
    }

    public CompletableFuture<Void> func_215226_a(IFutureReloadListener.IStage stage, IResourceManager resourceManager, IProfiler preparationsProfiler, IProfiler reloadProfiler, Executor backgroundExecutor, Executor gameExecutor) {
        return stage.func_216872_a((Object)Unit.INSTANCE).thenRunAsync(() -> {
            reloadProfiler.func_219894_a();
            reloadProfiler.func_76320_a("listener");
            this.reload(resourceManager);
            reloadProfiler.func_76319_b();
            reloadProfiler.func_219897_b();
        }, gameExecutor);
    }
}

