/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.inventory.container;

import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.CraftResultInventory;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.CraftingResultSlot;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeBookCategory;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SSetSlotPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.PacketDistributor;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.common.CuriosRegistry;
import top.theillusivec4.curios.common.inventory.CosmeticCurioSlot;
import top.theillusivec4.curios.common.inventory.CurioSlot;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.client.CPacketScroll;
import top.theillusivec4.curios.common.network.server.SPacketScroll;

public class CuriosContainer
extends PlayerContainer {
    private static final ResourceLocation[] ARMOR_SLOT_TEXTURES = new ResourceLocation[]{PlayerContainer.field_226619_g_, PlayerContainer.field_226618_f_, PlayerContainer.field_226617_e_, PlayerContainer.field_226616_d_};
    private static final EquipmentSlotType[] VALID_EQUIPMENT_SLOTS = new EquipmentSlotType[]{EquipmentSlotType.HEAD, EquipmentSlotType.CHEST, EquipmentSlotType.LEGS, EquipmentSlotType.FEET};
    public final LazyOptional<ICuriosItemHandler> curiosHandler;
    private final PlayerEntity player;
    private final boolean isLocalWorld;
    private CraftingInventory craftMatrix = new CraftingInventory((Container)this, 2, 2);
    private CraftResultInventory craftResult = new CraftResultInventory();
    private int lastScrollIndex;
    private boolean cosmeticColumn;

    public CuriosContainer(int windowId, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(windowId, playerInventory);
    }

    public CuriosContainer(int windowId, PlayerInventory playerInventory) {
        super(playerInventory, playerInventory.field_70458_d.field_70170_p.field_72995_K, playerInventory.field_70458_d);
        this.field_216965_e = CuriosRegistry.CONTAINER_TYPE;
        this.field_75152_c = windowId;
        this.field_75153_a.clear();
        this.field_75151_b.clear();
        this.player = playerInventory.field_70458_d;
        this.isLocalWorld = this.player.field_70170_p.field_72995_K;
        this.curiosHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)this.player);
        this.func_75146_a((Slot)new CraftingResultSlot(playerInventory.field_70458_d, this.craftMatrix, (IInventory)this.craftResult, 0, 154, 28));
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                this.func_75146_a(new Slot((IInventory)this.craftMatrix, j + i * 2, 98 + j * 18, 18 + i * 18));
            }
        }
        for (int k = 0; k < 4; ++k) {
            final EquipmentSlotType equipmentslottype = VALID_EQUIPMENT_SLOTS[k];
            this.func_75146_a(new Slot((IInventory)playerInventory, 36 + (3 - k), 8, 8 + k * 18){

                public int func_75219_a() {
                    return 1;
                }

                public boolean func_75214_a(@Nonnull ItemStack stack) {
                    return stack.canEquip(equipmentslottype, (Entity)CuriosContainer.this.player);
                }

                public boolean func_82869_a(@Nonnull PlayerEntity playerIn) {
                    ItemStack itemstack = this.func_75211_c();
                    return (itemstack.func_190926_b() || playerIn.func_184812_l_() || !EnchantmentHelper.func_190938_b((ItemStack)itemstack)) && super.func_82869_a(playerIn);
                }

                @OnlyIn(value=Dist.CLIENT)
                public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                    return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)ARMOR_SLOT_TEXTURES[equipmentslottype.func_188454_b()]);
                }
            });
        }
        for (int l = 0; l < 3; ++l) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.func_75146_a(new Slot((IInventory)playerInventory, j1 + (l + 1) * 9, 8 + j1 * 18, 84 + l * 18));
            }
        }
        for (int i1 = 0; i1 < 9; ++i1) {
            this.func_75146_a(new Slot((IInventory)playerInventory, i1, 8 + i1 * 18, 142));
        }
        this.func_75146_a(new Slot((IInventory)playerInventory, 40, 77, 62){

            @OnlyIn(value=Dist.CLIENT)
            public Pair<ResourceLocation, ResourceLocation> func_225517_c_() {
                return Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);
            }
        });
        this.curiosHandler.ifPresent(curios -> {
            int i;
            IDynamicStackHandler stackHandler;
            ICurioStacksHandler stacksHandler;
            Map<String, ICurioStacksHandler> curioMap = curios.getCurios();
            int slots = 0;
            int yOffset = 12;
            for (String identifier : curioMap.keySet()) {
                stacksHandler = curioMap.get(identifier);
                stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (i = 0; i < stackHandler.getSlots() && slots < 8; ++slots, ++i) {
                    this.func_75146_a((Slot)new CurioSlot(this.player, stackHandler, i, identifier, -18, yOffset, stacksHandler.getRenders()));
                    yOffset += 18;
                }
            }
            yOffset = 12;
            slots = 0;
            for (String identifier : curioMap.keySet()) {
                stacksHandler = curioMap.get(identifier);
                stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (i = 0; i < stackHandler.getSlots() && slots < 8; ++slots, ++i) {
                    if (stacksHandler.hasCosmetic()) {
                        IDynamicStackHandler cosmeticHandler = stacksHandler.getCosmeticStacks();
                        this.cosmeticColumn = true;
                        this.func_75146_a((Slot)new CosmeticCurioSlot(this.player, cosmeticHandler, i, identifier, -37, yOffset));
                    }
                    yOffset += 18;
                }
            }
        });
        this.scrollToIndex(0);
    }

    public boolean hasCosmeticColumn() {
        return this.cosmeticColumn;
    }

    public void resetSlots() {
        this.scrollToIndex(this.lastScrollIndex);
    }

    public void scrollToIndex(int indexIn) {
        this.curiosHandler.ifPresent(curios -> {
            int i;
            IDynamicStackHandler stackHandler;
            ICurioStacksHandler stacksHandler;
            Map<String, ICurioStacksHandler> curioMap = curios.getCurios();
            int slots = 0;
            int yOffset = 12;
            int index = 0;
            this.field_75151_b.subList(46, this.field_75151_b.size()).clear();
            if (this.field_75153_a != null) {
                this.field_75153_a.subList(46, this.field_75153_a.size()).clear();
            }
            for (String identifier : curioMap.keySet()) {
                stacksHandler = curioMap.get(identifier);
                stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (i = 0; i < stackHandler.getSlots() && slots < 8; ++i) {
                    if (index >= indexIn) {
                        this.func_75146_a((Slot)new CurioSlot(this.player, stackHandler, i, identifier, -18, yOffset, stacksHandler.getRenders()));
                        yOffset += 18;
                        ++slots;
                    }
                    ++index;
                }
            }
            index = 0;
            slots = 0;
            yOffset = 12;
            for (String identifier : curioMap.keySet()) {
                stacksHandler = curioMap.get(identifier);
                stackHandler = stacksHandler.getStacks();
                if (!stacksHandler.isVisible()) continue;
                for (i = 0; i < stackHandler.getSlots() && slots < 8; ++i) {
                    if (index >= indexIn) {
                        if (stacksHandler.hasCosmetic()) {
                            IDynamicStackHandler cosmeticHandler = stacksHandler.getCosmeticStacks();
                            this.cosmeticColumn = true;
                            this.func_75146_a((Slot)new CosmeticCurioSlot(this.player, cosmeticHandler, i, identifier, -37, yOffset));
                        }
                        yOffset += 18;
                        ++slots;
                    }
                    ++index;
                }
            }
            if (!this.isLocalWorld) {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)this.player), (Object)new SPacketScroll(this.field_75152_c, indexIn));
            }
            this.lastScrollIndex = indexIn;
        });
    }

    public void scrollTo(float pos) {
        this.curiosHandler.ifPresent(curios -> {
            int k = curios.getVisibleSlots() - 8;
            int j = (int)((double)(pos * (float)k) + 0.5);
            if (j < 0) {
                j = 0;
            }
            if (j == this.lastScrollIndex) {
                return;
            }
            if (this.isLocalWorld) {
                NetworkHandler.INSTANCE.send(PacketDistributor.SERVER.noArg(), (Object)new CPacketScroll(this.field_75152_c, j));
            }
        });
    }

    public void func_75130_a(@Nonnull IInventory inventoryIn) {
        if (!this.player.field_70170_p.field_72995_K) {
            ICraftingRecipe craftingRecipe;
            ServerPlayerEntity playerMP = (ServerPlayerEntity)this.player;
            ItemStack stack = ItemStack.field_190927_a;
            MinecraftServer server = this.player.field_70170_p.func_73046_m();
            if (server == null) {
                return;
            }
            Optional recipe = server.func_199529_aN().func_215371_a(IRecipeType.field_222149_a, (IInventory)this.craftMatrix, this.player.field_70170_p);
            if (recipe.isPresent() && this.craftResult.func_201561_a(this.player.field_70170_p, playerMP, (IRecipe)(craftingRecipe = (ICraftingRecipe)recipe.get()))) {
                stack = craftingRecipe.func_77572_b((IInventory)this.craftMatrix);
            }
            this.craftResult.func_70299_a(0, stack);
            playerMP.field_71135_a.func_147359_a((IPacket)new SSetSlotPacket(this.field_75152_c, 0, stack));
        }
    }

    public void func_75134_a(@Nonnull PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.craftResult.func_174888_l();
        if (!playerIn.field_70170_p.field_72995_K) {
            this.func_193327_a(playerIn, playerIn.field_70170_p, (IInventory)this.craftMatrix);
        }
    }

    public boolean canScroll() {
        return this.curiosHandler.map(curios -> {
            if (curios.getVisibleSlots() > 8) {
                return 1;
            }
            return 0;
        }).orElse(0) == 1;
    }

    public boolean func_75145_c(@Nonnull PlayerEntity playerIn) {
        return true;
    }

    @Nonnull
    public ItemStack func_82846_b(@Nonnull PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            int i;
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            EquipmentSlotType entityequipmentslot = MobEntity.func_184640_d((ItemStack)itemstack);
            if (index == 0) {
                if (!this.func_75135_a(itemstack1, 9, 45, true)) {
                    return ItemStack.field_190927_a;
                }
                slot.func_75220_a(itemstack1, itemstack);
            } else if (index < 5 ? !this.func_75135_a(itemstack1, 9, 45, false) : (index < 9 ? !this.func_75135_a(itemstack1, 9, 45, false) : (entityequipmentslot.func_188453_a() == EquipmentSlotType.Group.ARMOR && !((Slot)this.field_75151_b.get(8 - entityequipmentslot.func_188454_b())).func_75216_d() ? !this.func_75135_a(itemstack1, i = 8 - entityequipmentslot.func_188454_b(), i + 1, false) : (index < 46 && !CuriosApi.getCuriosHelper().getCurioTags(itemstack.func_77973_b()).isEmpty() ? !this.func_75135_a(itemstack1, 46, this.field_75151_b.size(), false) : (entityequipmentslot == EquipmentSlotType.OFFHAND && !((Slot)this.field_75151_b.get(45)).func_75216_d() ? !this.func_75135_a(itemstack1, 45, 46, false) : (index < 36 ? !this.func_75135_a(itemstack1, 36, 45, false) : (index < 45 ? !this.func_75135_a(itemstack1, 9, 36, false) : !this.func_75135_a(itemstack1, 9, 45, false)))))))) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
            if (itemstack1.func_190916_E() == itemstack.func_190916_E()) {
                return ItemStack.field_190927_a;
            }
            ItemStack itemstack2 = slot.func_190901_a(playerIn, itemstack1);
            if (index == 0) {
                playerIn.func_71019_a(itemstack2, false);
            }
        }
        return itemstack;
    }

    @Nonnull
    public RecipeBookCategory func_241850_m() {
        return RecipeBookCategory.CRAFTING;
    }

    public void func_201771_a(@Nonnull RecipeItemHelper itemHelperIn) {
        this.craftMatrix.func_194018_a(itemHelperIn);
    }

    public void func_201768_e() {
        this.craftMatrix.func_174888_l();
        this.craftResult.func_174888_l();
    }

    public boolean func_201769_a(IRecipe<? super CraftingInventory> recipeIn) {
        return recipeIn.func_77569_a((IInventory)this.craftMatrix, this.player.field_70170_p);
    }

    public int func_201767_f() {
        return 0;
    }

    public int func_201770_g() {
        return this.craftMatrix.func_174922_i();
    }

    public int func_201772_h() {
        return this.craftMatrix.func_174923_h();
    }

    public int func_203721_h() {
        return 5;
    }
}

