/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.Main;
import de.maxhenkel.voicechat.debug.CooldownTimer;
import de.maxhenkel.voicechat.voice.common.AuthenticateAckPacket;
import de.maxhenkel.voicechat.voice.common.AuthenticatePacket;
import de.maxhenkel.voicechat.voice.common.GroupSoundPacket;
import de.maxhenkel.voicechat.voice.common.KeepAlivePacket;
import de.maxhenkel.voicechat.voice.common.LocationSoundPacket;
import de.maxhenkel.voicechat.voice.common.MicPacket;
import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.common.Packet;
import de.maxhenkel.voicechat.voice.common.PingPacket;
import de.maxhenkel.voicechat.voice.common.PlayerSoundPacket;
import de.maxhenkel.voicechat.voice.common.PlayerState;
import de.maxhenkel.voicechat.voice.server.ClientConnection;
import de.maxhenkel.voicechat.voice.server.PingManager;
import de.maxhenkel.voicechat.voice.server.PlayerStateManager;
import de.maxhenkel.voicechat.voice.server.ServerWorldUtils;
import java.net.BindException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.MinecraftServer;

public class Server
extends Thread {
    private Map<UUID, ClientConnection> connections;
    private Map<UUID, UUID> secrets;
    private int port;
    private MinecraftServer server;
    private DatagramSocket socket;
    private ProcessThread processThread;
    private BlockingQueue<NetworkMessage.UnprocessedNetworkMessage> packetQueue;
    private PingManager pingManager;
    private PlayerStateManager playerStateManager;

    public Server(int port, MinecraftServer server) {
        this.port = port;
        this.server = server;
        this.connections = new HashMap<UUID, ClientConnection>();
        this.secrets = new HashMap<UUID, UUID>();
        this.packetQueue = new LinkedBlockingQueue<NetworkMessage.UnprocessedNetworkMessage>();
        this.pingManager = new PingManager(this);
        this.playerStateManager = new PlayerStateManager();
        this.setDaemon(true);
        this.setName("VoiceChatServerThread");
        this.processThread = new ProcessThread();
        this.processThread.start();
    }

    @Override
    public void run() {
        try {
            InetAddress address = null;
            String addr = (String)Main.SERVER_CONFIG.voiceChatBindAddress.get();
            try {
                if (!addr.isEmpty()) {
                    address = InetAddress.getByName(addr);
                }
            }
            catch (Exception e) {
                Main.LOGGER.error("Failed to parse bind IP address '" + addr + "'");
                Main.LOGGER.info("Binding to default IP address");
                e.printStackTrace();
            }
            try {
                try {
                    this.socket = new DatagramSocket(this.port, address);
                }
                catch (BindException e) {
                    if (address == null || addr.equals("0.0.0.0")) {
                        throw e;
                    }
                    Main.LOGGER.fatal("Failed to bind to address '" + addr + "', binding to '0.0.0.0' instead");
                    this.socket = new DatagramSocket(this.port);
                }
                this.socket.setTrafficClass(4);
            }
            catch (BindException e) {
                Main.LOGGER.error("Failed to bind to address '" + addr + "'");
                e.printStackTrace();
                System.exit(1);
                return;
            }
            Main.LOGGER.info("Server started at port " + this.port);
            while (!this.socket.isClosed()) {
                try {
                    this.packetQueue.add(NetworkMessage.readPacket(this.socket));
                }
                catch (Exception exception) {}
            }
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
    }

    public UUID getSecret(UUID playerUUID) {
        if (this.secrets.containsKey(playerUUID)) {
            return this.secrets.get(playerUUID);
        }
        UUID secret = UUID.randomUUID();
        this.secrets.put(playerUUID, secret);
        return secret;
    }

    public void disconnectClient(UUID playerUUID) {
        this.connections.remove(playerUUID);
        this.secrets.remove(playerUUID);
    }

    public void close() {
        this.socket.close();
        this.processThread.close();
    }

    private void processMicPacket(ServerPlayerEntity player, MicPacket packet) throws Exception {
        PlayerState state = this.playerStateManager.getState(player.func_110124_au());
        if (state == null) {
            return;
        }
        if (state.hasGroup()) {
            this.processGroupPacket(state, packet);
            if (((Boolean)Main.SERVER_CONFIG.openGroups.get()).booleanValue()) {
                this.processProximityPacket(state, player, packet);
            }
        }
        this.processProximityPacket(state, player, packet);
    }

    private void processGroupPacket(PlayerState player, MicPacket packet) throws Exception {
        String group = player.getGroup();
        NetworkMessage soundMessage = new NetworkMessage(new GroupSoundPacket(player.getGameProfile().getId(), packet.getData(), packet.getSequenceNumber()));
        for (PlayerState state : this.playerStateManager.getStates()) {
            ClientConnection connection;
            if (!group.equals(state.getGroup()) || player.getGameProfile().getId().equals(state.getGameProfile().getId()) || (connection = this.connections.get(state.getGameProfile().getId())) == null) continue;
            connection.send(this, soundMessage);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processProximityPacket(PlayerState state, ServerPlayerEntity player, MicPacket packet) {
        void var7_8;
        double distance = (Double)Main.SERVER_CONFIG.voiceChatDistance.get();
        String group = state.getGroup();
        if (player.func_175149_v()) {
            if (!((Boolean)Main.SERVER_CONFIG.spectatorInteraction.get()).booleanValue()) return;
            LocationSoundPacket locationSoundPacket = new LocationSoundPacket(player.func_110124_au(), player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0), packet.getData(), packet.getSequenceNumber());
        } else {
            PlayerSoundPacket playerSoundPacket = new PlayerSoundPacket(player.func_110124_au(), packet.getData(), packet.getSequenceNumber());
        }
        NetworkMessage soundMessage = new NetworkMessage((Packet<?>)var7_8);
        ServerWorldUtils.getPlayersInRange(player.func_71121_q(), player.func_213303_ch(), distance, p -> !p.func_110124_au().equals(player.func_110124_au())).parallelStream().map(p -> this.playerStateManager.getState(p.func_110124_au())).filter(Objects::nonNull).filter(s -> !s.isDisabled() && !s.isDisconnected()).filter(s -> !s.hasGroup() || !s.getGroup().equals(group)).map(p -> this.connections.get(p.getGameProfile().getId())).filter(Objects::nonNull).forEach(clientConnection -> {
            try {
                clientConnection.send(this, soundMessage);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }

    private void sendKeepAlives() throws Exception {
        long timestamp = System.currentTimeMillis();
        this.connections.values().removeIf(connection -> {
            if (timestamp - connection.getLastKeepAliveResponse() >= (long)((Integer)Main.SERVER_CONFIG.keepAlive.get()).intValue() * 10L) {
                this.secrets.remove(connection.getPlayerUUID());
                Main.LOGGER.info("Player {} timed out", (Object)connection.getPlayerUUID());
                ServerPlayerEntity player = this.server.func_184103_al().func_177451_a(connection.getPlayerUUID());
                if (player != null) {
                    Main.LOGGER.info("Reconnecting player {}", (Object)player.func_145748_c_().getString());
                    Main.SERVER.initializePlayerConnection(player);
                } else {
                    Main.LOGGER.warn("Reconnecting player {} failed (Could not find player)", (Object)connection.getPlayerUUID());
                }
                return true;
            }
            return false;
        });
        for (ClientConnection connection2 : this.connections.values()) {
            this.sendPacket(new KeepAlivePacket(), connection2);
        }
    }

    public Map<UUID, ClientConnection> getConnections() {
        return this.connections;
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    public void sendPacket(Packet<?> packet, ClientConnection connection) throws Exception {
        connection.send(this, new NetworkMessage(packet));
    }

    public PingManager getPingManager() {
        return this.pingManager;
    }

    public PlayerStateManager getPlayerStateManager() {
        return this.playerStateManager;
    }

    private class ProcessThread
    extends Thread {
        private boolean running = true;
        private long lastKeepAlive = 0L;

        public ProcessThread() {
            this.setDaemon(true);
            this.setName("VoiceChatPacketProcessingThread");
        }

        @Override
        public void run() {
            while (this.running) {
                try {
                    UUID playerUUID;
                    NetworkMessage message;
                    NetworkMessage.UnprocessedNetworkMessage msg;
                    Server.this.pingManager.checkTimeouts();
                    long keepAliveTime = System.currentTimeMillis();
                    if (keepAliveTime - this.lastKeepAlive > (long)((Integer)Main.SERVER_CONFIG.keepAlive.get()).intValue()) {
                        Server.this.sendKeepAlives();
                        this.lastKeepAlive = keepAliveTime;
                    }
                    if ((msg = (NetworkMessage.UnprocessedNetworkMessage)Server.this.packetQueue.poll(10L, TimeUnit.MILLISECONDS)) == null) continue;
                    try {
                        message = NetworkMessage.readPacketServer(msg, Server.this);
                    }
                    catch (Exception e) {
                        CooldownTimer.run("failed_reading_packet", () -> Main.LOGGER.warn("Failed to read packet from {}", (Object)msg.getPacket().getSocketAddress()));
                        continue;
                    }
                    if (System.currentTimeMillis() - message.getTimestamp() > message.getTTL()) {
                        CooldownTimer.run("ttl", () -> {
                            Main.LOGGER.warn("Dropping voice chat packets! Your Server might be overloaded!");
                            Main.LOGGER.warn("Packet queue has {} packets", (Object)Server.this.packetQueue.size());
                        });
                        continue;
                    }
                    if (message.getPacket() instanceof AuthenticatePacket) {
                        AuthenticatePacket packet = (AuthenticatePacket)message.getPacket();
                        UUID secret = (UUID)Server.this.secrets.get(packet.getPlayerUUID());
                        if (secret != null && secret.equals(packet.getSecret())) {
                            ClientConnection connection;
                            if (!Server.this.connections.containsKey(packet.getPlayerUUID())) {
                                connection = new ClientConnection(packet.getPlayerUUID(), message.getAddress());
                                Server.this.connections.put(packet.getPlayerUUID(), connection);
                                Main.LOGGER.info("Successfully authenticated player {}", (Object)packet.getPlayerUUID());
                            } else {
                                connection = (ClientConnection)Server.this.connections.get(packet.getPlayerUUID());
                            }
                            Server.this.sendPacket(new AuthenticateAckPacket(), connection);
                        }
                    }
                    if ((playerUUID = message.getSender(Server.this)) == null) continue;
                    ClientConnection conn = (ClientConnection)Server.this.connections.get(playerUUID);
                    if (message.getPacket() instanceof MicPacket) {
                        MicPacket packet = (MicPacket)message.getPacket();
                        ServerPlayerEntity player = Server.this.server.func_184103_al().func_177451_a(playerUUID);
                        if (player == null) continue;
                        Server.this.processMicPacket(player, packet);
                        continue;
                    }
                    if (message.getPacket() instanceof PingPacket) {
                        Server.this.pingManager.onPongPacket((PingPacket)message.getPacket());
                        continue;
                    }
                    if (!(message.getPacket() instanceof KeepAlivePacket)) continue;
                    conn.setLastKeepAliveResponse(System.currentTimeMillis());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void close() {
            this.running = false;
        }
    }
}

