/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.server;

import de.maxhenkel.voicechat.voice.common.NetworkMessage;
import de.maxhenkel.voicechat.voice.server.Server;
import java.net.DatagramPacket;
import java.net.SocketAddress;
import java.util.UUID;

public class ClientConnection {
    private UUID playerUUID;
    private SocketAddress address;
    private long lastKeepAliveResponse;

    public ClientConnection(UUID playerUUID, SocketAddress address) {
        this.playerUUID = playerUUID;
        this.address = address;
        this.lastKeepAliveResponse = System.currentTimeMillis();
    }

    public UUID getPlayerUUID() {
        return this.playerUUID;
    }

    public SocketAddress getAddress() {
        return this.address;
    }

    public long getLastKeepAliveResponse() {
        return this.lastKeepAliveResponse;
    }

    public void setLastKeepAliveResponse(long lastKeepAliveResponse) {
        this.lastKeepAliveResponse = lastKeepAliveResponse;
    }

    public void send(Server server, NetworkMessage message) throws Exception {
        byte[] data = message.write(server.getSecret(this.playerUUID));
        server.getSocket().send(new DatagramPacket(data, data.length, this.address));
    }
}

